/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.quartz.service.impl;

import com.lc.ibps.components.quartz.service.AbstractService;
import com.lc.ibps.components.quartz.service.ITriggerQueryService;
import java.util.HashMap;
import java.util.List;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class TriggerQueryServiceImpl
extends AbstractService
implements ITriggerQueryService {
    public boolean isTriggerExists(String triggerName, String schedGroup) throws SchedulerException {
        this.verify();
        TriggerKey triggerKey = new TriggerKey(triggerName, schedGroup);
        return this.scheduler.checkExists(triggerKey);
    }

    public Trigger getTrigger(String triggerName, String schedGroup) throws SchedulerException {
        this.verify();
        TriggerKey triggerKey = new TriggerKey(triggerName, schedGroup);
        return this.scheduler.getTrigger(triggerKey);
    }

    public List<Trigger> findTriggersByJob(String jobName, String schedGroup) throws SchedulerException {
        this.verify();
        JobKey key = new JobKey(jobName, schedGroup);
        return this.scheduler.getTriggersOfJob(key);
    }

    public HashMap<String, Trigger.TriggerState> getTriggerStatus(List<Trigger> list) throws SchedulerException {
        this.verify();
        HashMap<String, Trigger.TriggerState> map = new HashMap<String, Trigger.TriggerState>();
        for (Trigger trigger : list) {
            TriggerKey key = trigger.getKey();
            Trigger.TriggerState state = this.scheduler.getTriggerState(key);
            map.put(key.getName(), state);
        }
        return map;
    }
}

