/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.quartz.service.impl;

import com.lc.ibps.base.core.util.time.DateFormatUtil;
import com.lc.ibps.components.quartz.model.PlanObject;
import com.lc.ibps.components.quartz.service.AbstractService;
import com.lc.ibps.components.quartz.service.ITriggerQueryService;
import com.lc.ibps.components.quartz.service.ITriggerService;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class TriggerServiceImpl
extends AbstractService
implements ITriggerService {
    private ITriggerQueryService triggerQueryService;
    private static HashMap<String, String> mapWeek = new HashMap();

    public void setTriggerQueryService(ITriggerQueryService triggerQueryService) {
        this.triggerQueryService = triggerQueryService;
    }

    public void addTrigger(String jobName, String triggerName, String planJson, String schedGroup) throws SchedulerException, ParseException {
        this.verify();
        boolean isJobExist = this.triggerQueryService.isTriggerExists(triggerName, schedGroup);
        if (isJobExist) {
            throw new SchedulerException("\u5b9a\u65f6\u8ba1\u5212\u5df2\u5b58\u5728!");
        }
        TriggerBuilder tb = TriggerBuilder.newTrigger();
        tb.withIdentity(triggerName, schedGroup);
        this.setTrigBuilder(planJson, (TriggerBuilder<Trigger>)tb);
        tb.forJob(jobName, schedGroup);
        Trigger trig = tb.build();
        this.scheduler.scheduleJob(trig);
    }

    public void addTrigger(String jobName, String triggerName, String schedGroup) throws SchedulerException, ParseException {
        this.verify();
        Trigger trig = this.triggerQueryService.getTrigger(triggerName, schedGroup);
        trig.getTriggerBuilder().forJob(jobName, schedGroup);
        this.scheduler.scheduleJob(trig);
    }

    public void delTrigger(String triggerName, String schedGroup) throws SchedulerException {
        this.verify();
        TriggerKey key = new TriggerKey(triggerName, schedGroup);
        this.scheduler.unscheduleJob(key);
    }

    public boolean run(String triggerName, String schedGroup) throws SchedulerException {
        this.verify();
        TriggerKey key = new TriggerKey(triggerName, schedGroup);
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        if (state == Trigger.TriggerState.PAUSED) {
            this.scheduler.resumeTrigger(key);
            return true;
        }
        return state == Trigger.TriggerState.NORMAL;
    }

    public boolean stop(String triggerName, String schedGroup) throws SchedulerException {
        this.verify();
        TriggerKey key = new TriggerKey(triggerName, schedGroup);
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        if (state == Trigger.TriggerState.PAUSED) {
            return true;
        }
        if (state == Trigger.TriggerState.NORMAL) {
            this.scheduler.pauseTrigger(key);
            return true;
        }
        return false;
    }

    private void setTrigBuilder(String planJson, TriggerBuilder<Trigger> tb) throws ParseException {
        JSONObject jsonObject = JSONObject.fromObject((Object)planJson);
        PlanObject planObject = (PlanObject)JSONObject.toBean((JSONObject)jsonObject, PlanObject.class);
        int type = planObject.getType();
        String value = planObject.getTimeInterval();
        CronScheduleBuilder sb = null;
        switch (type) {
            case 1: {
                Date date = DateFormatUtil.parseDateTime((String)value);
                tb.startAt(date).withDescription("\u6267\u884c\u4e00\u6b21,\u6267\u884c\u65f6\u95f4:" + DateFormatUtil.format((Object)date));
                break;
            }
            case 2: {
                int minute = Integer.parseInt(value);
                sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInMinutes(minute);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + minute + "\u5206\u949f\u6267\u884c!");
                break;
            }
            case 3: {
                String[] aryTime = value.split(":");
                int hour = Integer.parseInt(aryTime[0]);
                int m = Integer.parseInt(aryTime[1]);
                sb = CronScheduleBuilder.dailyAtHourAndMinute((int)hour, (int)m);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf\u5929\uff1a" + hour + ":" + m + "\u6267\u884c!");
                break;
            }
            case 4: {
                String[] aryExpression = value.split("[|]");
                String week = aryExpression[0];
                String[] aryTime1 = aryExpression[1].split(":");
                String h1 = aryTime1[0];
                String m1 = aryTime1[1];
                String cronExperssion = "0 " + m1 + " " + h1 + " ? * " + week;
                sb = CronScheduleBuilder.cronSchedule((String)cronExperssion);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf\u5468\uff1a" + this.getWeek(week) + "," + h1 + ":" + m1 + "\u6267\u884c!");
                break;
            }
            case 5: {
                String[] aryExpression5 = value.split("[|]");
                String day = aryExpression5[0];
                String[] aryTime2 = aryExpression5[1].split(":");
                String h2 = aryTime2[0];
                String m2 = aryTime2[1];
                String cronExperssion1 = "0 " + m2 + " " + h2 + " " + day + " * ?";
                sb = CronScheduleBuilder.cronSchedule((String)cronExperssion1);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf\u6708:" + this.getDay(day) + "," + h2 + ":" + m2 + "\u6267\u884c!");
                break;
            }
            case 6: {
                sb = CronScheduleBuilder.cronSchedule((String)value);
                tb.startNow().withSchedule((ScheduleBuilder)sb);
                tb.withDescription("CronTrigger\u8868\u8fbe\u5f0f:" + value);
            }
        }
    }

    private String getWeek(String week) {
        String[] aryWeek = week.split(",");
        int len = aryWeek.length;
        String str = "";
        for (int i = 0; i < len; ++i) {
            str = i < len - 1 ? str + mapWeek.get(aryWeek[i]) + "," : str + mapWeek.get(aryWeek[i]);
        }
        return str;
    }

    private String getDay(String day) {
        String[] aryDay = day.split(",");
        int len = aryDay.length;
        String str = "";
        for (int i = 0; i < len; ++i) {
            String tmp = aryDay[i];
            tmp = tmp.equals("L") ? "\u6700\u540e\u4e00\u5929" : tmp + "\u65e5";
            str = i < len - 1 ? str + tmp + "," : str + tmp;
        }
        return str;
    }

    static {
        mapWeek.put("MON", "\u661f\u671f\u4e00");
        mapWeek.put("TUE", "\u661f\u671f\u4e8c");
        mapWeek.put("WED", "\u661f\u671f\u4e09");
        mapWeek.put("THU", "\u661f\u671f\u56db");
        mapWeek.put("FRI", "\u661f\u671f\u4e94");
        mapWeek.put("SAT", "\u661f\u671f\u516d");
        mapWeek.put("SUN", "\u661f\u671f\u65e5");
    }
}

