/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.upload.impl;

import com.bugull.mongo.fs.BuguFS;
import com.bugull.mongo.fs.BuguFSFactory;
import com.bugull.mongo.fs.Uploader;
import com.lc.ibps.base.core.encrypt.EncryptUtil;
import com.lc.ibps.base.core.util.AppUtil;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.components.upload.constants.SaveType;
import com.lc.ibps.components.upload.impl.AbstractUploadService;
import com.lc.ibps.components.upload.model.FileInfo;
import com.lc.ibps.components.upload.util.UploadUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class UploadServiceMongoDbImpl
extends AbstractUploadService {
    private String bucketName = AppUtil.getProperty((String)"file.bucket", (String)"ibps");
    private String chunkSize = AppUtil.getProperty((String)"file.chunkSize", (String)"1024");

    public String getSaveType() {
        return SaveType.mongodb.name();
    }

    public FileInfo uploadFile(InputStream is, Map<String, Object> params) throws Exception {
        String fileMd5 = (String)params.get("fileMd5");
        String chunk = (String)params.get("chunk");
        this.saveFileData(is, fileMd5, chunk);
        FileInfo fileInfo = this.fileInfoPersistenceService.initFileInfo();
        if (StringUtil.isNotEmpty((CharSequence)fileMd5)) {
            this.saveFileData(is, fileMd5, chunk);
        } else {
            fileInfo = this.getFileInfo(fileInfo, params);
            fileMd5 = EncryptUtil.encryptFileMd5((InputStream)is);
            chunk = "0";
            fileInfo.setMd5(fileMd5);
            this.saveFileData(is, fileMd5, chunk);
            fileInfo = this.fileInfoPersistenceService.save(fileInfo, params);
        }
        return fileInfo;
    }

    private void saveFileData(InputStream is, String fileMd5, String chunk) {
        Uploader uploader = new Uploader(is, fileMd5 + "/" + chunk);
        uploader.setBucket(this.bucketName);
        uploader.setChunkSize(new Integer(this.chunkSize) * 1024);
        uploader.setAttribute("fileMd5", (Object)fileMd5);
        uploader.save();
    }

    public void deleteFile(String[] deleteIds) throws Exception {
        for (int i = 0; i < deleteIds.length; ++i) {
            String deleteId = deleteIds[i];
            FileInfo loaclUpload = this.fileInfoPersistenceService.getLoaclUpload(deleteId);
            if (BeanUtils.isEmpty((Object)loaclUpload)) {
                this.logger.warn("\u6839\u636e\u4e3b\u952eId\uff1a" + deleteId + ",\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53");
                continue;
            }
            BuguFS buguFS = this.getBuguFS();
            BasicDBObject query = new BasicDBObject("fileMd5", (Object)loaclUpload.getMd5());
            buguFS.remove((DBObject)query);
            this.fileInfoPersistenceService.deleteInfo(deleteId);
        }
    }

    public FileInfo downloadFile(String downloadId) throws Exception {
        BasicDBObject query;
        FileInfo fileInfo = this.fileInfoPersistenceService.getLoaclUpload(downloadId);
        BuguFS buguFS = this.getBuguFS();
        List list = buguFS.find((DBObject)(query = new BasicDBObject("fileMd5", (Object)fileInfo.getMd5())));
        if (BeanUtils.isEmpty((Object)list)) {
            return fileInfo;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        block0: for (GridFSDBFile f : list) {
            InputStream is = f.getInputStream();
            int read = -1;
            int bufferSize = (int)f.getChunkSize();
            byte[] buffer = new byte[bufferSize];
            int remain = (int)f.getLength();
            int readSize = Math.min(bufferSize, remain);
            while ((read = is.read(buffer, 0, readSize)) != -1) {
                baos.write(buffer, 0, read);
                if ((remain -= read) <= 0) continue block0;
                readSize = Math.min(bufferSize, remain);
            }
        }
        fileInfo.setFileBytes(baos.toByteArray());
        return fileInfo;
    }

    private BuguFS getBuguFS() {
        return BuguFSFactory.getInstance().create(this.bucketName, new Integer(this.chunkSize) * 1024);
    }

    public boolean checkChunk(Map<String, Object> params) {
        String chunk = (String)params.get("chunk");
        String fileMd5 = (String)params.get("fileMd5");
        String chunkSize = (String)params.get("chunkSize");
        GridFSDBFile checkFile = this.getBuguFS().findOne(fileMd5 + "/" + chunk);
        return !BeanUtils.isNotEmpty((Object)checkFile) || checkFile.getLength() != (long)Integer.parseInt(chunkSize);
    }

    public FileInfo mergeChunks(Map<String, Object> params) throws Exception {
        FileInfo fileInfo = this.getFileInfo(params);
        return this.fileInfoPersistenceService.save(fileInfo, params);
    }

    private FileInfo getFileInfo(FileInfo fileInfo, Map<String, Object> params) throws Exception {
        fileInfo = UploadUtil.getFileInfo((FileInfo)fileInfo, params);
        return fileInfo;
    }

    private FileInfo getFileInfo(Map<String, Object> params) throws Exception {
        FileInfo fileInfo = this.fileInfoPersistenceService.initFileInfo();
        return this.getFileInfo(fileInfo, params);
    }

    public FileInfo saveFile(Map<String, Object> params) throws Exception {
        FileInfo fileInfo = this.getFileInfo(params);
        return this.fileInfoPersistenceService.save(fileInfo, params);
    }

    public boolean checkFileExists(FileInfo fileInfo) {
        return true;
    }
}

