/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.form.service.impl;

import com.lc.ibps.api.bo.model.IBoDef;
import com.lc.ibps.api.bo.service.IBoDefService;
import com.lc.ibps.api.form.model.IFormDef;
import com.lc.ibps.api.form.service.IFormDefService;
import com.lc.ibps.api.form.sql.util.BeanUtils;
import com.lc.ibps.bpmn.api.model.define.IBpmDefine;
import com.lc.ibps.bpmn.api.service.BpmDefineService;
import com.lc.ibps.components.codegen.model.TableModel;
import com.lc.ibps.components.codegen.service.ITableModelService;
import com.lc.ibps.form.service.IBoRemoveService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BoRemoveServiceImpl
implements IBoRemoveService {
    @Resource
    private IBoDefService boDefService;
    @Resource
    private IFormDefService formDefService;
    @Resource
    private BpmDefineService bpmDefineService;
    @Resource
    private ITableModelService tableModelService;

    @Override
    public List<IBoDef> findRelationBoDefByBoId(String[] boIds) {
        ArrayList<IBoDef> result = new ArrayList<IBoDef>();
        if (BeanUtils.isEmpty((Object)boIds)) {
            return result;
        }
        for (String defId : boIds) {
            List tmpDefs = this.boDefService.findParents(defId);
            result.removeAll(tmpDefs);
            result.addAll(tmpDefs);
        }
        return result;
    }

    @Override
    public List<IFormDef> findRelationFormDefByBoId(String[] boIds) {
        return this.formDefService.findByBoIds(boIds);
    }

    @Override
    public List<IBpmDefine> findRelationBpmDefByBoId(String[] boIds) {
        if (BeanUtils.isEmpty((Object)boIds)) {
            return Collections.emptyList();
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (String boId : boIds) {
            IBoDef bo = this.boDefService.getById(boId);
            if (BeanUtils.isEmpty((Object)bo)) continue;
            codes.add(bo.getCode());
        }
        return this.bpmDefineService.findByBoCodes(codes.toArray(new String[codes.size()]));
    }

    @Override
    public List<TableModel> findRelationTableConfigByBoId(String[] boIds) {
        if (BeanUtils.isEmpty((Object)boIds)) {
            return Collections.emptyList();
        }
        ArrayList<TableModel> result = new ArrayList<TableModel>();
        TableModel tableModel = null;
        for (String boId : boIds) {
            tableModel = this.tableModelService.getByBoId(boId, false);
            if (BeanUtils.isEmpty((Object)tableModel)) continue;
            result.add(tableModel);
        }
        return result;
    }
}

