/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.data;

import com.lc.ibps.api.bo.model.IBoDef;
import com.lc.ibps.api.bo.model.IDataObject;
import com.lc.ibps.base.bo.exception.BoBaseException;
import com.lc.ibps.base.bo.persistence.entity.BoAttributePo;
import com.lc.ibps.base.bo.persistence.entity.BoDefPo;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.base.core.util.time.DateFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractDataObject
implements IDataObject {
    protected String id;
    protected String tenantId;
    protected String curUserId;
    protected String optIp;
    protected int version;
    protected int pageVersion;
    protected Date createTime;
    protected String defId;
    protected IBoDef iboDef;
    protected String attrName;
    protected String saveType;
    protected Boolean initialize = false;

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public String getCurUserId() {
        return this.curUserId;
    }

    public void setCurUserId(String string) {
        this.curUserId = string;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String string) {
        this.tenantId = string;
    }

    public String getOptIp() {
        return this.optIp;
    }

    public void setOptIp(String string) {
        this.optIp = string;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getPageVersion() {
        return this.pageVersion;
    }

    public void setPageVersion(int n) {
        this.pageVersion = n;
    }

    public String getDefId() {
        return this.defId;
    }

    public void setDefId(String string) {
        this.defId = string;
    }

    public void setCreateTime(Date date) {
        this.createTime = date;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getSaveType() {
        return this.saveType;
    }

    public void setSaveType(String string) {
        this.saveType = string;
    }

    public IBoDef getIboDef() {
        return this.iboDef;
    }

    public void setIboDef(IBoDef iBoDef) {
        this.iboDef = iBoDef;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("defId", (Object)this.defId).append("data", (Object)this.getData()).append("boDef", (Object)this.iboDef).append("attrName", (Object)this.attrName).append("saveType", (Object)this.saveType).append("createTime", (Object)this.createTime).toString();
    }

    public String getString(String object) {
        if (BeanUtils.isNotEmpty((Object)(object = this.get((String)object)))) {
            return object.toString();
        }
        return "";
    }

    public Integer getInt(String string) {
        return Integer.parseInt(StringUtil.isBlank((CharSequence)(string = this.getString(string).replaceAll(",", ""))) ? "0" : string);
    }

    public Long getLong(String string) {
        return Long.parseLong(StringUtil.isBlank((CharSequence)(string = this.getString(string).replaceAll(",", ""))) ? "0" : string);
    }

    public Float getFloat(String string) {
        return Float.valueOf(Float.parseFloat(StringUtil.isBlank((CharSequence)(string = this.getString(string).replaceAll(",", ""))) ? "0" : string));
    }

    public Short getShort(String string) {
        return Short.parseShort(StringUtil.isBlank((CharSequence)(string = this.getString(string).replaceAll(",", ""))) ? "0" : string);
    }

    public Boolean getBoolean(String string) {
        return Boolean.parseBoolean(StringUtil.isBlank((CharSequence)(string = this.getString(string))) ? "false" : string);
    }

    public Date getDate(String string) {
        BoAttributePo boAttributePo = this.getAttributeByPath(string);
        if (BeanUtils.isEmpty((Object)(string = this.getString(string)))) {
            return null;
        }
        String string2 = "";
        if (BeanUtils.isNotEmpty((Object)boAttributePo)) {
            string2 = boAttributePo.getFormat();
        }
        try {
            if (BeanUtils.isEmpty((Object)string2)) {
                return DateFormatUtil.parse((String)string);
            }
            return DateFormatUtil.parse((String)string, (String)string2);
        }
        catch (Exception exception) {
            throw new BoBaseException("\u5c06\u83b7\u53d6\u7684\u503c\u8f6c\u6362\u4e3aDate\u7c7b\u578b\u65f6\u51fa\u9519\u4e86,\u65e5\u671f\u7684\u503c:" + string + ",\u65e5\u671f\u7684\u683c\u5f0f:" + string2);
        }
    }

    public IDataObject getDataObject(String object) {
        BoDefPo boDefPo = this.getSubBoDefByPath((String)object);
        if (BeanUtils.isEmpty((Object)boDefPo)) {
            return null;
        }
        if (BeanUtils.isEmpty((Object)(object = this.get((String)object)))) {
            return null;
        }
        return this.createSubDataObject(boDefPo, object);
    }

    public void setDataObject(String string, IDataObject iDataObject) {
        this.set(string, iDataObject == null ? null : iDataObject.getData());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<IDataObject> getDataObjects(String object) {
        BoDefPo boDefPo = this.getSubBoDefByPath((String)object);
        ArrayList<IDataObject> arrayList = new ArrayList<IDataObject>();
        if (BeanUtils.isEmpty((Object)(object = this.get((String)object)))) {
            return arrayList;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (BeanUtils.isEmpty((Object)list)) {
                return arrayList;
            }
            for (Object e : list) {
                IDataObject iDataObject;
                if (BeanUtils.isEmpty(e) || !BeanUtils.isNotEmpty((Object)(iDataObject = this.createSubDataObject(boDefPo, e)))) continue;
                arrayList.add(iDataObject);
            }
            return arrayList;
        } else if (object instanceof String) {
            try {
                for (Object e : JSONArray.fromObject((Object)object)) {
                    IDataObject iDataObject;
                    if (BeanUtils.isEmpty(e) || !BeanUtils.isNotEmpty((Object)(iDataObject = this.createSubDataObject(boDefPo, e)))) continue;
                    arrayList.add(iDataObject);
                }
                return arrayList;
            }
            catch (Exception exception) {
                IDataObject iDataObject = this.createSubDataObject(boDefPo, object);
                if (!BeanUtils.isNotEmpty((Object)iDataObject)) return arrayList;
                arrayList.add(iDataObject);
                return arrayList;
            }
        } else {
            IDataObject iDataObject = this.createSubDataObject(boDefPo, object);
            if (!BeanUtils.isNotEmpty((Object)iDataObject)) return arrayList;
            arrayList.add(iDataObject);
        }
        return arrayList;
    }

    public void setDataObjects(String string, List<IDataObject> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        object = object.iterator();
        while (object.hasNext()) {
            IDataObject iDataObject = (IDataObject)object.next();
            arrayList.add(iDataObject.getData());
        }
        this.set(string, arrayList);
    }

    public void put(String string, IDataObject iDataObject) {
        List<IDataObject> list = this.getDataObjects(string);
        list.add(iDataObject);
        this.setDataObjects(string, list);
    }

    public String getAttrName() {
        return this.attrName;
    }

    public void setAttrName(String string) {
        this.attrName = string;
    }

    public Boolean isInitialize() {
        return this.initialize;
    }

    public void setInitialize(Boolean bl) {
        this.initialize = bl;
    }

    public abstract BoAttributePo getAttributeByPath(String var1);

    public abstract BoDefPo getSubBoDefByPath(String var1);

    public abstract IDataObject createSubDataObject(BoDefPo var1, Object var2);
}

