/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.persistence.builder;

import com.lc.ibps.base.bo.constants.DataFormat;
import com.lc.ibps.base.bo.persistence.entity.BoAttributePo;
import com.lc.ibps.base.bo.persistence.entity.BoDefPo;
import com.lc.ibps.base.bo.persistence.vo.TreeVo;
import com.lc.ibps.base.bo.repository.BoDefRepository;
import com.lc.ibps.base.bo.strategy.BoDefStrategyFactory;
import com.lc.ibps.base.core.util.AppUtil;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.json.JsonUtil;
import com.lc.ibps.base.framework.page.PageList;
import com.lc.ibps.base.framework.table.model.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;

public class BoDefBuilder {
    private BoDefBuilder() {
    }

    public static BoDefPo build(String string, String string2) {
        if (JsonUtil.isEmpty((Object)(string = JSONArray.fromObject((Object)string)))) {
            return null;
        }
        string = string.getJSONObject(0);
        string = BoDefStrategyFactory.get(DataFormat.JSON).parse(string.toString());
        if (BeanUtils.isEmpty((Object)string)) {
            return null;
        }
        string.setSaveType(string2);
        return string;
    }

    public static BoDefPo buildFromDB(String string, String string2) {
        if (JsonUtil.isEmpty((Object)(string = JSONArray.fromObject((Object)string)))) {
            return null;
        }
        string = string.getJSONObject(0);
        string = BoDefStrategyFactory.get(DataFormat.JSON).parseFromDB(string.toString());
        if (BeanUtils.isEmpty((Object)string)) {
            return null;
        }
        string.setSaveType(string2);
        return string;
    }

    public static void updateFromTable(BoDefPo boDefPo, Map<String, Table> map) {
        if (BeanUtils.isEmpty((Object)boDefPo) || BeanUtils.isEmpty(map)) {
            return;
        }
        BoDefStrategyFactory.get(DataFormat.JSON).updateFromTable(boDefPo, map);
    }

    public static PageList<BoDefPo> buildList(PageList<BoDefPo> pageList) {
        BoDefRepository boDefRepository = (BoDefRepository)AppUtil.getBean(BoDefRepository.class);
        for (BoDefPo boDefPo : pageList) {
            boDefPo.setVersionCount(boDefRepository.getVersionCountCode(boDefPo.getCode()));
        }
        return pageList;
    }

    public static List<TreeVo> buildBoTree(BoDefPo boDefPo, String iterator) {
        ArrayList<TreeVo> arrayList = new ArrayList<TreeVo>();
        if (BeanUtils.isEmpty((Object)boDefPo)) {
            return arrayList;
        }
        boolean bl = iterator == "0";
        arrayList.add(new TreeVo(boDefPo.getId(), boDefPo.getName(), boDefPo.getCode(), (String)((Object)iterator), "table", bl ? "table" : "subTable", boDefPo.getCode(), "fa fa-table"));
        if (BeanUtils.isEmpty((Object)boDefPo.getAttrList())) {
            return arrayList;
        }
        for (BoAttributePo boAttributePo : boDefPo.getAttrList()) {
            arrayList.add(new TreeVo(boAttributePo.getId(), boAttributePo.getName(), boAttributePo.getCode(), boDefPo.getId(), boAttributePo.getDataType(), bl ? "field" : "subField", boDefPo.getCode(), "fa fa-" + boAttributePo.getDataType(), boAttributePo.getFormat()));
        }
        for (BoAttributePo boAttributePo : boDefPo.getSubDefList()) {
            arrayList.addAll(BoDefBuilder.buildBoTree((BoDefPo)boAttributePo, boDefPo.getId()));
        }
        return arrayList;
    }
}

