/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.service.impl;

import com.lc.ibps.api.bo.model.IDataObject;
import com.lc.ibps.api.bo.service.IBoInstanceService;
import com.lc.ibps.api.bo.vo.BoResultVo;
import com.lc.ibps.base.bo.domain.BoInstance;
import com.lc.ibps.base.bo.exception.BoBaseException;
import com.lc.ibps.base.bo.exception.DataObjectException;
import com.lc.ibps.base.bo.repository.BoInstanceRepository;
import com.lc.ibps.base.bo.validator.DataObjectErrors;
import com.lc.ibps.base.bo.validator.DataObjectValidator;
import com.lc.ibps.base.core.monitor.StopWatchUtil;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.json.JsonUtil;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
public class DefaultBoInstanceService
implements IBoInstanceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BO_CODE_NULL = "bo\u5b9a\u4e49\u7f16\u7801\u4e3a\u7a7a";
    private static final String BO_VERSION_NULL = "bo\u5b9a\u4e49\u7248\u672c\u4e3a\u7a7a";
    private static final String BO_DATA_NULL = "bo\u5b9a\u4e49\u6570\u636e\u4e3a\u7a7a";
    private static final String BO_DATA_MODE_NULL = "bo\u6570\u636e\u4fdd\u5b58\u6a21\u5f0f\u4e3a\u7a7a";
    @Resource
    private BoInstanceRepository boInstanceRepository;
    @Autowired
    private DataObjectValidator dataObjectValidator;
    private MessageSourceAccessor messages;

    @Autowired
    public void setMessages(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public IDataObject createDataObject(String string) {
        if (BeanUtils.isEmpty((Object)string)) {
            throw new BoBaseException(BO_CODE_NULL);
        }
        return this.boInstanceRepository.getDataObjectByCode(string);
    }

    public IDataObject createDataObject(String string, Integer n) {
        if (BeanUtils.isEmpty((Object)string)) {
            throw new BoBaseException(BO_CODE_NULL);
        }
        if (BeanUtils.isEmpty((Object)n)) {
            throw new BoBaseException(BO_VERSION_NULL);
        }
        return this.boInstanceRepository.getDataObjectByCode(string, n);
    }

    public IDataObject createDataObject(String string, Object object) {
        if (BeanUtils.isEmpty((Object)string)) {
            throw new BoBaseException(BO_CODE_NULL);
        }
        if (BeanUtils.isEmpty((Object)object)) {
            throw new BoBaseException(BO_DATA_NULL);
        }
        this.logger.debug("data is #### {} ####", object);
        return this.boInstanceRepository.getDataObjectByCode(string, object);
    }

    public IDataObject createDataObject(String string, Integer n, Object object) {
        if (BeanUtils.isEmpty((Object)string)) {
            throw new BoBaseException(BO_CODE_NULL);
        }
        if (BeanUtils.isEmpty((Object)n)) {
            throw new BoBaseException(BO_VERSION_NULL);
        }
        if (BeanUtils.isEmpty((Object)object)) {
            throw new BoBaseException(BO_DATA_NULL);
        }
        this.logger.debug("data is #### {} ####", object);
        return this.boInstanceRepository.getDataObjectByCode(string, n, object);
    }

    /*
     * Unable to fully structure code
     */
    public BoResultVo save(String var1_1, IDataObject var2_2) {
        if (BeanUtils.isEmpty((Object)var1_1)) {
            throw new BoBaseException("bo\u6570\u636e\u4fdd\u5b58\u6a21\u5f0f\u4e3a\u7a7a");
        }
        if (BeanUtils.isEmpty((Object)var2_2)) {
            throw new BoBaseException("bo\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a");
        }
        StopWatchUtil.stopAndStartNew((String)"BpmInstController", (String)"start", (String)"getBpmStartEvent.PREV.addBusRel.handSaveBoData.save.isOpenConflict");
        if (BeanUtils.isNotEmpty((Object)var2_2.getId()) && JsonUtil.isEmpty((Object)(var3_3 = var2_2.getFormOptions())) == false && JsonUtil.isEmpty((Object)(var3_3 = JsonUtil.getJSONobject((JSONObject)JSONObject.fromObject((Object)var3_3), (String)"attrs"))) == false && JsonUtil.isNotEmpty((Object)(var3_3 = JsonUtil.getString((JSONObject)var3_3, (String)"conflict"))) != false && "Y".equalsIgnoreCase(var3_3) != false) {
            var3_4 = var2_2.getVersion();
            var4_6 = var2_2.getPageVersion();
            if (var4_6 != 0 && BeanUtils.isNotEmpty((Object)var3_4) && var4_6 != var3_4) {
                throw new BoBaseException("\u7248\u672c\u53d1\u751f\u53d8\u5316\uff0c\u6570\u636e\u5df2\u7ecf\u88ab\u4fee\u6539\uff01");
            }
        }
        StopWatchUtil.stopAndStartNew((String)"BpmInstController", (String)"start", (String)"getBpmStartEvent.PREV.addBusRel.handSaveBoData.save.isOpenFormValidate");
        var3_5 = var2_2;
        if (BeanUtils.isEmpty((Object)var3_5) || JsonUtil.isEmpty((Object)(var3_5 = var3_5.getFormOptions()))) ** GOTO lbl-1000
        if (JsonUtil.isEmpty((Object)(var3_5 = JsonUtil.getJSONobject((JSONObject)JSONObject.fromObject((Object)var3_5), (String)"attrs")))) {
            v0 = true;
        } else if (JsonUtil.isEmpty((Object)(var3_5 = JsonUtil.getString((JSONObject)var3_5, (String)"validated"))) || "Y".equalsIgnoreCase((String)var3_5)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            var3_5 = new DataObjectErrors(this.messages);
            this.dataObjectValidator.validate(var2_2, (Errors)var3_5);
            if (var3_5.hasErrors()) {
                throw new DataObjectException(var3_5.toString());
            }
        }
        StopWatchUtil.stopAndStartNew((String)"BpmInstController", (String)"start", (String)"getBpmStartEvent.PREV.addBusRel.handSaveBoData.save.newInstance");
        var3_5 = (BoInstance)this.boInstanceRepository.newInstance();
        StopWatchUtil.stopAndStartNew((String)"BpmInstController", (String)"start", (String)"getBpmStartEvent.PREV.addBusRel.handSaveBoData.save.saveDataObject");
        return var3_5.saveDataObject(var1_1, var2_2);
    }

    public void mergerDataObject(IDataObject iDataObject, Object object) {
        if (BeanUtils.isEmpty((Object)iDataObject)) {
            throw new BoBaseException("bo\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (BeanUtils.isEmpty((Object)object)) {
            throw new BoBaseException(BO_DATA_NULL);
        }
        this.logger.debug("data is #### {} ####", object);
        this.boInstanceRepository.mergerDataObject(iDataObject, object);
    }

    public IDataObject getDataObject(String string, String string2, String string3) {
        if (BeanUtils.isEmpty((Object)string)) {
            throw new BoBaseException(BO_DATA_MODE_NULL);
        }
        if (BeanUtils.isEmpty((Object)string2)) {
            throw new BoBaseException("\u4e1a\u52a1ID\u4e3a\u7a7a");
        }
        if (BeanUtils.isEmpty((Object)string3)) {
            throw new BoBaseException(BO_CODE_NULL);
        }
        return this.boInstanceRepository.getDataObject(string, string2, string3);
    }

    public IDataObject getDataObject(String string, String string2, String string3, Integer n) {
        if (BeanUtils.isEmpty((Object)string)) {
            throw new BoBaseException(BO_DATA_MODE_NULL);
        }
        if (BeanUtils.isEmpty((Object)string2)) {
            throw new BoBaseException("\u4e1a\u52a1ID\u4e3a\u7a7a");
        }
        if (BeanUtils.isEmpty((Object)string3)) {
            throw new BoBaseException(BO_CODE_NULL);
        }
        if (BeanUtils.isEmpty((Object)n)) {
            throw new BoBaseException(BO_VERSION_NULL);
        }
        return this.boInstanceRepository.getDataObject(string, string2, string3, n);
    }

    public void removeDataObject(String string, String string2, String[] stringArray) {
        ((BoInstance)this.boInstanceRepository.newInstance()).removeDataObject(string, string2, stringArray);
    }

    public void removeDataObject(String string, String string2, Integer n, String[] stringArray) {
        ((BoInstance)this.boInstanceRepository.newInstance()).removeDataObject(string, string2, n, stringArray);
    }
}

