/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.validator;

import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringFormater;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.validation.AbstractErrors;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ObjectError;

public class DataObjectErrors
extends AbstractErrors {
    private final String MODEL_KEY_PREFIX;
    private String objectName;
    private MessageSourceAccessor messages;
    private MessageCodesResolver messageCodesResolver;
    private final List<ObjectError> errors;

    public DataObjectErrors(MessageSourceAccessor messageSourceAccessor) {
        this.objectName = this.MODEL_KEY_PREFIX = DataObjectErrors.class.getName() + ".";
        this.messageCodesResolver = new DefaultMessageCodesResolver();
        this.errors = new LinkedList<ObjectError>();
        this.messages = messageSourceAccessor;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void addError(ObjectError objectError) {
        this.errors.add(objectError);
    }

    public String[] resolveMessageCodes(String string) {
        return this.getMessageCodesResolver().resolveMessageCodes(string, this.getObjectName());
    }

    public MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public void reject(String string, Object[] objectArray, String string2) {
        this.addError(new ObjectError(this.getObjectName(), this.resolveMessageCodes(string), objectArray, string2));
    }

    public void rejectValue(String string, String string2, Object[] objectArray, String string3) {
        this.reject(string2, objectArray, string3);
    }

    public void addAllErrors(Errors errors) {
        if (!errors.getObjectName().equals(this.getObjectName())) {
            throw new IllegalArgumentException("Errors object needs to have same object name");
        }
        this.errors.addAll(errors.getAllErrors());
    }

    public List<ObjectError> getGlobalErrors() {
        LinkedList<ObjectError> linkedList = new LinkedList<ObjectError>();
        for (ObjectError objectError : this.errors) {
            if (objectError instanceof FieldError) continue;
            linkedList.add(objectError);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public List<FieldError> getFieldErrors() {
        LinkedList<FieldError> linkedList = new LinkedList<FieldError>();
        for (ObjectError objectError : this.errors) {
            if (!(objectError instanceof FieldError)) continue;
            linkedList.add((FieldError)objectError);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public Object getFieldValue(String string) {
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\u8868\u5355\u9a8c\u8bc1\u51fa\u9519");
        stringBuilder.append(": ").append(this.getErrorCount()).append(" \u5904\u9519\u8bef</br>");
        for (Object object : this.getAllErrors()) {
            object = BeanUtils.isNotEmpty((Object)this.messages) ? this.messages.getMessage(object.getCode(), object.getArguments(), object.getDefaultMessage()) : StringFormater.formatStr((String)object.getDefaultMessage(), (Object[])object.getArguments());
            stringBuilder.append((String)object).append("</br>");
        }
        return stringBuilder.toString();
    }
}

