/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.validator.constraints.impl;

import com.lc.ibps.base.bo.validator.constraints.AbstractValidator;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringConverter;
import com.lc.ibps.base.core.util.string.StringValidator;
import java.math.BigDecimal;
import java.util.List;
import net.sf.json.JSONObject;

public class DigitsValidator
extends AbstractValidator {
    private boolean isInteger = false;
    private Integer maxFractionLength;
    private String code;

    @Override
    public void initialize(Object object, JSONObject jSONObject) {
        super.initialize(object, jSONObject);
        object = this;
        ((DigitsValidator)object).isInteger = StringConverter.toBoolean((String)((AbstractValidator)object).getFieldOptionByKey("integer"));
        ((DigitsValidator)object).maxFractionLength = StringConverter.toInteger((String)((AbstractValidator)object).getFieldOptionByKey("decimal"));
        if (((DigitsValidator)object).maxFractionLength != null) {
            ((DigitsValidator)object).isInteger = false;
            return;
        }
        if (((DigitsValidator)object).isInteger) {
            ((DigitsValidator)object).isInteger = true;
        }
    }

    @Override
    public boolean isValid() {
        int n;
        if (BeanUtils.isEmpty((Object)this.value)) {
            return true;
        }
        if (!StringValidator.isRoundNumber((String)this.value.toString())) {
            this.code = "number";
            return false;
        }
        BigDecimal bigDecimal = this.value instanceof BigDecimal ? new BigDecimal(this.value.toString()).stripTrailingZeros() : new BigDecimal(this.value.toString()).stripTrailingZeros();
        int n2 = n = bigDecimal.scale() < 0 ? 0 : bigDecimal.scale();
        if (this.isInteger) {
            this.code = "integer";
            return n <= 0;
        }
        if (this.maxFractionLength != null && this.maxFractionLength > 0) {
            this.code = "digits";
            return this.maxFractionLength >= n;
        }
        return true;
    }

    @Override
    public List<Object> getErrorArgs() {
        List<Object> list = super.getErrorArgs();
        list.add(this.maxFractionLength);
        return list;
    }

    @Override
    public String getMessage() {
        if (this.isInteger) {
            return "\u5fc5\u987b\u586b\u5199\u6574\u6570";
        }
        return "\u5c0f\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc7{1}\u4f4d";
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

