/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.validator.constraints.impl;

import com.lc.ibps.base.bo.validator.constraints.AbstractValidator;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringConverter;
import java.util.List;
import net.sf.json.JSONObject;

public class ItemValidator
extends AbstractValidator {
    private Integer min;
    private Integer max;
    private String code = "item";

    @Override
    public void initialize(Object object, JSONObject jSONObject) {
        super.initialize(object, jSONObject);
        this.min = StringConverter.toInteger((String)this.getFieldOptionByKey("min_mum"));
        this.max = StringConverter.toInteger((String)this.getFieldOptionByKey("max_mum"));
    }

    @Override
    public boolean isValid() {
        if (this.max == null && this.min == null || BeanUtils.isEmpty((Object)this.value)) {
            return true;
        }
        int n = this.value.toString().split(",").length;
        if (BeanUtils.isNotEmpty((Object)this.max) && BeanUtils.isNotEmpty((Object)this.min)) {
            this.code = "rangeitem";
            return n >= this.min && n <= this.max;
        }
        if (BeanUtils.isNotEmpty((Object)this.max) && BeanUtils.isEmpty((Object)this.min)) {
            this.code = "maxitem";
            return n <= this.max;
        }
        this.code = "minitem";
        return n >= this.min;
    }

    @Override
    public List<Object> getErrorArgs() {
        List<Object> list = super.getErrorArgs();
        if (this.code.equalsIgnoreCase("maxitem")) {
            list.add(this.max);
        } else if (this.code.equalsIgnoreCase("minitem")) {
            list.add(this.min);
        } else {
            list.add(this.min);
            list.add(this.max);
        }
        return list;
    }

    @Override
    public String getMessage() {
        return "\u8bf7\u9009\u62e9\u9009\u9879";
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

