/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.validator.constraints.impl;

import com.lc.ibps.base.bo.validator.constraints.AbstractValidator;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringConverter;
import java.util.List;
import net.sf.json.JSONObject;

public class LengthValidator
extends AbstractValidator {
    private Integer max;
    private Integer min;
    private String code = "rangelength";

    @Override
    public void initialize(Object object, JSONObject jSONObject) {
        super.initialize(object, jSONObject);
        this.max = StringConverter.toInteger((String)this.getFieldOptionByKey("max_length"));
        this.min = StringConverter.toInteger((String)this.getFieldOptionByKey("min_length"));
        object = this;
        if (((LengthValidator)object).max == null || ((LengthValidator)object).min == null) {
            return;
        }
        if (((LengthValidator)object).min < 0) {
            throw new IllegalArgumentException("The min parameter cannot be negative.");
        }
        if (((LengthValidator)object).max < 0) {
            throw new IllegalArgumentException("The max parameter cannot be negative.");
        }
        if (((LengthValidator)object).max < ((LengthValidator)object).min) {
            throw new IllegalArgumentException("The length cannot be negative.");
        }
    }

    @Override
    public boolean isValid() {
        if (this.max == null && this.min == null || BeanUtils.isEmpty((Object)this.value)) {
            return true;
        }
        int n = this.value.toString().length();
        if (BeanUtils.isNotEmpty((Object)this.max) && BeanUtils.isNotEmpty((Object)this.min)) {
            this.code = "rangelength";
            return n >= this.min && n <= this.max;
        }
        if (BeanUtils.isNotEmpty((Object)this.max) && BeanUtils.isEmpty((Object)this.min)) {
            this.code = "maxlength";
            return n <= this.max;
        }
        this.code = "minlength";
        return n >= this.min;
    }

    @Override
    public List<Object> getErrorArgs() {
        List<Object> list = super.getErrorArgs();
        if (this.code.equalsIgnoreCase("maxlength")) {
            list.add(this.max);
        } else if (this.code.equalsIgnoreCase("minlength")) {
            list.add(this.min);
        } else {
            list.add(this.min);
            list.add(this.max);
        }
        return list;
    }

    @Override
    public String getMessage() {
        if (this.code.equalsIgnoreCase("maxlength")) {
            return "\u6700\u591a {1} \u4e2a\u5b57\u7b26";
        }
        if (this.code.equalsIgnoreCase("minlength")) {
            return "\u6700\u5c11 {1} \u4e2a\u5b57\u7b26";
        }
        return "\u957f\u5ea6\u5728 {1} \u5230 {2} \u5b57\u7b26\u8303\u56f4\u5185";
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

