/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.validator.constraints.impl;

import com.lc.ibps.api.bo.constants.FieldDataFormat;
import com.lc.ibps.base.bo.validator.constraints.AbstractValidator;
import com.lc.ibps.base.core.util.BeanUtils;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;

public class PatternValidator
extends AbstractValidator {
    private Pattern pattern;
    private String code = "regex";
    private String msg = "";
    private int intFlag = 0;

    @Override
    public void initialize(Object object, JSONObject object2) {
        super.initialize(object, (JSONObject)object2);
        object = this.getFieldOptionByKey("data_format");
        this.msg = this.getFieldOptionByKey("data_format_msg");
        if (BeanUtils.isNotEmpty((Object)object)) {
            object2 = this.getFieldOptionByKey("data_format_value");
            object = FieldDataFormat.fromKey((String)object);
            try {
                if (object != null) {
                    this.code = object.key();
                    this.msg = object.label();
                    this.pattern = Pattern.compile(object.reg(), this.intFlag);
                    return;
                }
                this.code = "regex";
                if (BeanUtils.isNotEmpty((Object)object2)) {
                    this.pattern = Pattern.compile((String)object2, this.intFlag);
                }
                return;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new IllegalArgumentException("Invalid regular expression.", patternSyntaxException);
            }
        }
    }

    @Override
    public boolean isValid() {
        if (this.pattern == null || BeanUtils.isEmpty((Object)this.value)) {
            return true;
        }
        return this.pattern.matcher(this.value.toString()).matches();
    }

    @Override
    public List<Object> getErrorArgs() {
        List<Object> list = super.getErrorArgs();
        list.add(this.msg);
        return list;
    }

    @Override
    public String getMessage() {
        return "\u8bf7\u8f93\u5165\u6b63\u786e{1} ";
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

