/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.validator.constraints.impl;

import com.lc.ibps.base.bo.validator.constraints.AbstractValidator;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringConverter;
import java.math.BigDecimal;
import java.util.List;
import net.sf.json.JSONObject;

public class RangeValidator
extends AbstractValidator {
    private BigDecimal max;
    private BigDecimal min;
    private String code = "range";

    @Override
    public void initialize(Object object, JSONObject jSONObject) {
        super.initialize(object, jSONObject);
        this.max = StringConverter.toBigDecimal((String)this.getFieldOptionByKey("max"));
        this.min = StringConverter.toBigDecimal((String)this.getFieldOptionByKey("min"));
    }

    @Override
    public boolean isValid() {
        if (this.max == null && this.min == null || BeanUtils.isEmpty((Object)this.value)) {
            return true;
        }
        BigDecimal bigDecimal = StringConverter.toBigDecimal((String)this.value.toString());
        if (BeanUtils.isNotEmpty((Object)this.max) && BeanUtils.isNotEmpty((Object)this.min)) {
            this.code = "range";
            return bigDecimal.compareTo(this.max) != 1 && bigDecimal.compareTo(this.min) != -1;
        }
        if (BeanUtils.isNotEmpty((Object)this.max) && BeanUtils.isEmpty((Object)this.min)) {
            this.code = "max";
            return bigDecimal.compareTo(this.max) != 1;
        }
        this.code = "min";
        return bigDecimal.compareTo(this.min) != -1;
    }

    @Override
    public List<Object> getErrorArgs() {
        List<Object> list = super.getErrorArgs();
        if (this.code.equalsIgnoreCase("max")) {
            list.add(this.max);
        } else if (this.code.equalsIgnoreCase("min")) {
            list.add(this.min);
        } else {
            list.add(this.min);
            list.add(this.max);
        }
        return list;
    }

    @Override
    public String getMessage() {
        if (this.code.equalsIgnoreCase("max")) {
            return "\u6700\u5927\u503c {1}";
        }
        if (this.code.equalsIgnoreCase("min")) {
            return "\u6700\u5c0f\u503c {2} ";
        }
        return "{0} \u4e3a {1} \u5230 {2} \u4e4b\u95f4\u7684\u6570\u5b57";
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

