/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.bo.validator.utils;

import java.util.regex.Pattern;

public class RegExpValidatorUtils {
    public static boolean isEmail(String string) {
        return RegExpValidatorUtils.a("^([\\w-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([\\w-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$", string);
    }

    public static boolean isIP(String string) {
        String string2 = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
        return RegExpValidatorUtils.a("^" + string2 + "\\." + string2 + "\\." + string2 + "\\." + string2 + "$", string);
    }

    public static boolean isUrl(String string) {
        return RegExpValidatorUtils.a("http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?", string);
    }

    public static boolean isTelephone(String string) {
        return RegExpValidatorUtils.a("^(\\d{3,4}-)?\\d{6,8}$", string);
    }

    public static boolean isMobilephone(String string) {
        return RegExpValidatorUtils.a("^[1]+[3,5]+\\d{9}$", string);
    }

    public static boolean isPassword(String string) {
        return RegExpValidatorUtils.a("[A-Za-z]+[0-9]", string);
    }

    public static boolean isPasswordLength(String string) {
        return RegExpValidatorUtils.a("^\\d{6,18}$", string);
    }

    public static boolean isPostalCode(String string) {
        return RegExpValidatorUtils.a("^\\d{6}$", string);
    }

    public static boolean isIDCard(String string) {
        return RegExpValidatorUtils.a("(^\\d{18}$)|(^\\d{15}$)", string);
    }

    public static boolean isDecimal(String string) {
        return RegExpValidatorUtils.a("^[0-9]+(.[0-9]{2})?$", string);
    }

    public static boolean isMonth(String string) {
        return RegExpValidatorUtils.a("^(0?[[1-9]|1[0-2])$", string);
    }

    public static boolean isDay(String string) {
        return RegExpValidatorUtils.a("^((0?[1-9])|((1|2)[0-9])|30|31)$", string);
    }

    public static boolean isDate(String string) {
        return RegExpValidatorUtils.a("^((((1[6-9]|[2-9]\\d)\\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\\d|3[01]))|(((1[6-9]|[2-9]\\d)\\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\\d|30))|(((1[6-9]|[2-9]\\d)\\d{2})-0?2-(0?[1-9]|1\\d|2[0-8]))|(((1[6-9]|[2-9]\\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-)) (20|21|22|23|[0-1]?\\d):[0-5]?\\d:[0-5]?\\d$", string);
    }

    public static boolean isNumber(String string) {
        return Pattern.compile("^[-]?[0-9]+(\\.[0-9]{1,2})?$").matcher(string).matches();
    }

    public static boolean isIntNumber(String string) {
        return RegExpValidatorUtils.a("^\\+?[1-9][0-9]*$", string);
    }

    public static boolean isUpChar(String string) {
        return RegExpValidatorUtils.a("^[A-Z]+$", string);
    }

    public static boolean isLowChar(String string) {
        return RegExpValidatorUtils.a("^[a-z]+$", string);
    }

    public static boolean isLetter(String string) {
        return RegExpValidatorUtils.a("^[A-Za-z]+$", string);
    }

    public static boolean isChinese(String string) {
        return RegExpValidatorUtils.a("^[\u4e00-\u9fa5],{0,}$", string);
    }

    public static boolean isLength(String string) {
        return RegExpValidatorUtils.a("^.{8,}$", string);
    }

    private static boolean a(String string, String string2) {
        return Pattern.compile(string).matcher(string2).matches();
    }

    public static boolean isInteger(String string) {
        return Pattern.compile("^[-\\+]?[\\d]*$").matcher(string).matches();
    }
}

