/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CommonConfig {
    @Value(value="${encrypt.lock.enabled:false}")
    private boolean encryptLockEnabled;
    @Value(value="${encrypt.jdk.enabled:true}")
    private boolean encryptJdkEnabled;
    @Value(value="${hanyu.pinyin.lock.enabled:false}")
    private boolean hanyuPinyinLockEnabled;
    @Value(value="${stopwatch.enabled:false}")
    private boolean stopwatchEnabled;
    @Value(value="${bean.copier.enabled:true}")
    private boolean beanCopierEnabled;
    @Value(value="${groovy.pre.enabled:true}")
    private boolean groovyPreEnabled;
    @Value(value="${groovy.lock.enabled:false}")
    private boolean groovyLockEnabled;
    @Value(value="${groovy.timeout.enabled:false}")
    private boolean groovyTimeoutEnabled;
    @Value(value="${groovy.sandbox.enabled:true}")
    private boolean groovySandboxEnabled;
    @Value(value="${groovy.thread.interrupt.enabled:true}")
    private boolean groovyThreadInterruptEnabled;
    @Value(value="${groovy.timeout.ms:3000}")
    private Integer groovyTimeoutMs;
    @Value(value="${groovy.timeout.seconds:3000}")
    private Integer groovyTimeoutSeconds;
    @Value(value="${groovy.binding.interface.enabled:true}")
    private boolean groovyBindingInterfaceEnabled;
    @Value(value="${groovy.binding.interface.impls:}")
    private List<String> groovyBindingInterface;

    public boolean isEncryptLockEnabled() {
        return this.encryptLockEnabled;
    }

    public boolean isEncryptJdkEnabled() {
        return this.encryptJdkEnabled;
    }

    public boolean isHanyuPinyinLockEnabled() {
        return this.hanyuPinyinLockEnabled;
    }

    public boolean isStopwatchEnabled() {
        return this.stopwatchEnabled;
    }

    public boolean isBeanCopierEnabled() {
        return this.beanCopierEnabled;
    }

    public boolean isGroovyPreEnabled() {
        return this.groovyPreEnabled;
    }

    public boolean isGroovyLockEnabled() {
        return this.groovyLockEnabled;
    }

    public boolean isGroovyTimeoutEnabled() {
        return this.groovyTimeoutEnabled;
    }

    public boolean isGroovySandboxEnabled() {
        return this.groovySandboxEnabled;
    }

    public boolean isGroovyThreadInterruptEnabled() {
        return this.groovyThreadInterruptEnabled;
    }

    public Integer getGroovyTimeoutMs() {
        if (Objects.isNull(this.groovyTimeoutMs)) {
            return 3000;
        }
        if (this.groovyTimeoutMs <= 0) {
            return 3000;
        }
        return this.groovyTimeoutMs;
    }

    public Integer getGroovyTimeoutSeconds() {
        if (Objects.isNull(this.groovyTimeoutSeconds)) {
            return 3;
        }
        if (this.groovyTimeoutSeconds <= 0) {
            return 3;
        }
        return this.groovyTimeoutSeconds;
    }

    public boolean isGroovyBindingInterfaceEnabled() {
        return this.groovyBindingInterfaceEnabled;
    }

    public List<String> getGroovyBindingInterface() {
        if (Objects.isNull(this.groovyBindingInterface)) {
            return Lists.newArrayList();
        }
        return this.groovyBindingInterface;
    }
}

