/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.encrypt;

import com.lc.ibps.base.core.util.FileUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.CRC32;

public class CRC32Util {
    public static String encrypt(String inStr) {
        if (Objects.isNull(inStr) || inStr.length() == 0) {
            throw new IllegalArgumentException("The input is null or empty.");
        }
        return CRC32Util.encrypt(inStr.getBytes());
    }

    public static Long encryptToLong(String inStr) {
        if (Objects.isNull(inStr) || inStr.length() == 0) {
            throw new IllegalArgumentException("The input is null or empty.");
        }
        return CRC32Util.encryptToLong(inStr.getBytes());
    }

    public static String encrypt(byte[] bytes) {
        return CRC32Util.encryptToLong(bytes).toString();
    }

    public static Long encryptToLong(byte[] bytes) {
        if (Objects.isNull(bytes) || bytes.length == 0) {
            throw new IllegalArgumentException("The input is null or empty.");
        }
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return crc32.getValue();
    }

    public static String encryptFile(String fileName) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(fileName);
        return CRC32Util.encryptStream(is);
    }

    public static Long encryptFileToLong(String fileName) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(fileName);
        return CRC32Util.encryptStreamToLong(is);
    }

    public static String encryptStream(InputStream is) {
        return CRC32Util.encrypt(FileUtil.readByte(is));
    }

    public static Long encryptStreamToLong(InputStream is) {
        return CRC32Util.encryptToLong(FileUtil.readByte(is));
    }
}

