/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.encrypt;

import cn.hutool.crypto.asymmetric.RSA;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.springframework.data.util.Pair;

public class RSAUtil {
    private static final String ENCRYPT_ALGORITHM = "RSA";
    private static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final int maxEncryptBlockSize = 117;
    private static final int maxDecryptBlockSize = 128;
    private static final int maxEncryptBlockSize245 = 245;
    private static final int maxDecryptBlockSize256 = 256;

    public static String encrypt(String data, PublicKey publicKey) throws Exception {
        return RSAUtil.encrypt1024(data, publicKey);
    }

    public static String decrypt(String encryptedStr, PrivateKey privateKey) throws Exception {
        return RSAUtil.decrypt1024(encryptedStr, privateKey);
    }

    public static String encrypt1024(String data, PublicKey publicKey) throws Exception {
        byte[] encryptedData;
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, publicKey);
        byte[] inputData = data.getBytes(StandardCharsets.UTF_8);
        int inputLength = inputData.length;
        int offset = 0;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            while (inputLength - offset > 0) {
                byte[] block = inputLength - offset > 117 ? cipher.doFinal(inputData, offset, 117) : cipher.doFinal(inputData, offset, inputLength - offset);
                outputStream.write(block, 0, block.length);
                offset += 117;
            }
            encryptedData = outputStream.toByteArray();
        }
        return cn.hutool.core.codec.Base64.encode((byte[])encryptedData);
    }

    public static String decrypt1024(String encryptedStr, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, privateKey);
        byte[] encryptedData = cn.hutool.core.codec.Base64.decode((CharSequence)encryptedStr);
        int inputLength = encryptedData.length;
        int offset = 0;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            while (inputLength - offset > 0) {
                byte[] block = inputLength - offset > 128 ? cipher.doFinal(encryptedData, offset, 128) : cipher.doFinal(encryptedData, offset, inputLength - offset);
                outputStream.write(block, 0, block.length);
                offset += 128;
            }
            byte[] decryptedData = outputStream.toByteArray();
            String string = new String(decryptedData, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static String encrypt2048(String data, PublicKey publicKey) throws Exception {
        byte[] encryptedData;
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, publicKey);
        byte[] inputData = data.getBytes(StandardCharsets.UTF_8);
        int inputLength = inputData.length;
        int offset = 0;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            while (inputLength - offset > 0) {
                byte[] block = inputLength - offset > 245 ? cipher.doFinal(inputData, offset, 245) : cipher.doFinal(inputData, offset, inputLength - offset);
                outputStream.write(block, 0, block.length);
                offset += 245;
            }
            encryptedData = outputStream.toByteArray();
        }
        return cn.hutool.core.codec.Base64.encode((byte[])encryptedData);
    }

    public static String decrypt2048(String encryptedStr, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, privateKey);
        byte[] encryptedData = cn.hutool.core.codec.Base64.decode((CharSequence)encryptedStr);
        int inputLength = encryptedData.length;
        int offset = 0;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            while (inputLength - offset > 0) {
                byte[] block = inputLength - offset > 256 ? cipher.doFinal(encryptedData, offset, 256) : cipher.doFinal(encryptedData, offset, inputLength - offset);
                outputStream.write(block, 0, block.length);
                offset += 256;
            }
            byte[] decryptedData = outputStream.toByteArray();
            String string = new String(decryptedData, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static String encrypt2048ByNimbusJoseJwt(String data, PublicKey publicKey) throws Exception {
        JWEHeader header = new JWEHeader(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A128GCM);
        Payload payload = new Payload(data);
        JWEObject jweObject = new JWEObject(header, payload);
        jweObject.encrypt((JWEEncrypter)new RSAEncrypter((RSAPublicKey)publicKey));
        String encryptedData = jweObject.serialize();
        return encryptedData;
    }

    public static String decrypt2048ByNimbusJoseJwt(String encryptedStr, PrivateKey privateKey) throws Exception {
        String decryptedData;
        JWEObject jweObject = JWEObject.parse((String)encryptedStr);
        jweObject.decrypt((JWEDecrypter)new RSADecrypter(privateKey));
        String string = decryptedData = jweObject.getPayload().toString();
        return string;
    }

    public static PublicKey getPublicKey(String publicKey) throws Exception {
        byte[] bytes = publicKey.getBytes("UTF-8");
        return RSAUtil.getPublicKey(bytes);
    }

    public static PrivateKey getPrivateKey(String privateKey) throws Exception {
        byte[] bytes = privateKey.getBytes("UTF-8");
        return RSAUtil.getPrivateKey(bytes);
    }

    private static PublicKey getPublicKey(byte[] bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        bytes = Base64.getDecoder().decode(bytes);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance(ENCRYPT_ALGORITHM);
        return factory.generatePublic(spec);
    }

    private static PrivateKey getPrivateKey(byte[] bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        bytes = Base64.getDecoder().decode(bytes);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance(ENCRYPT_ALGORITHM);
        return factory.generatePrivate(spec);
    }

    public static Pair<String, String> generateKey1024(String secret) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ENCRYPT_ALGORITHM);
        SecureRandom secureRandom = new SecureRandom(secret.getBytes());
        keyPairGenerator.initialize(1024, secureRandom);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        byte[] publicKeyBytes = keyPair.getPublic().getEncoded();
        publicKeyBytes = Base64.getEncoder().encode(publicKeyBytes);
        byte[] privateKeyBytes = keyPair.getPrivate().getEncoded();
        privateKeyBytes = Base64.getEncoder().encode(privateKeyBytes);
        return Pair.of((Object)new String(publicKeyBytes, "UTF-8"), (Object)new String(privateKeyBytes, "UTF-8"));
    }

    public static Pair<String, String> generateKey2048(String secret) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ENCRYPT_ALGORITHM);
        SecureRandom secureRandom = new SecureRandom(secret.getBytes());
        keyPairGenerator.initialize(2048, secureRandom);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        byte[] publicKeyBytes = keyPair.getPublic().getEncoded();
        publicKeyBytes = Base64.getEncoder().encode(publicKeyBytes);
        byte[] privateKeyBytes = keyPair.getPrivate().getEncoded();
        privateKeyBytes = Base64.getEncoder().encode(privateKeyBytes);
        return Pair.of((Object)new String(publicKeyBytes, "UTF-8"), (Object)new String(privateKeyBytes, "UTF-8"));
    }

    public static Pair<String, String> generateKey(String secret, int keySize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ENCRYPT_ALGORITHM);
        SecureRandom secureRandom = new SecureRandom(secret.getBytes());
        keyPairGenerator.initialize(Math.max(1024, keySize), secureRandom);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        byte[] publicKeyBytes = keyPair.getPublic().getEncoded();
        publicKeyBytes = Base64.getEncoder().encode(publicKeyBytes);
        byte[] privateKeyBytes = keyPair.getPrivate().getEncoded();
        privateKeyBytes = Base64.getEncoder().encode(privateKeyBytes);
        return Pair.of((Object)new String(publicKeyBytes, "UTF-8"), (Object)new String(privateKeyBytes, "UTF-8"));
    }

    public static RSA createRSA(String primaryKey, String publicKey) {
        return new RSA(primaryKey, publicKey);
    }
}

