/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.encrypt;

import java.security.MessageDigest;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM3Util {
    private static final Logger log = LoggerFactory.getLogger(SM3Util.class);

    public static String hexEncrypt(String hexString) {
        byte[] srcData = Hex.decode((String)hexString);
        byte[] encrypt = SM3Util.encrypt(srcData);
        String cipherStr = Hex.toHexString((byte[])encrypt);
        return cipherStr;
    }

    public static String hexEncrypt(String hexKey, String hexString) {
        byte[] key = Hex.decode((String)hexKey);
        byte[] srcData = Hex.decode((String)hexString);
        byte[] encrypt = SM3Util.encrypt(key, srcData);
        String cipherStr = Hex.toHexString((byte[])encrypt);
        return cipherStr;
    }

    public static String encrypt(String plain) {
        String cipherStr = null;
        try {
            byte[] srcData = plain.getBytes("UTF-8");
            byte[] encrypt = SM3Util.encrypt(srcData);
            cipherStr = Hex.toHexString((byte[])encrypt);
        }
        catch (Exception e) {
            log.error("\u5c06\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u5b57\u8282\u65f6\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        return cipherStr;
    }

    public static String encrypt(String hexKey, String plain) {
        String cipherStr = null;
        try {
            byte[] srcData = plain.getBytes("UTF-8");
            byte[] key = Hex.decode((String)hexKey);
            byte[] encrypt = SM3Util.encrypt(key, srcData);
            cipherStr = Hex.toHexString((byte[])encrypt);
        }
        catch (Exception e) {
            log.error("\u5c06\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u5b57\u8282\u65f6\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        return cipherStr;
    }

    public static byte[] encrypt(byte[] srcData) {
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(srcData, 0, srcData.length);
        byte[] encrypt = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(encrypt, 0);
        return encrypt;
    }

    public static byte[] encrypt(byte[] key, byte[] srcData) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(srcData, 0, srcData.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    public static byte[] encrypt_0(byte[] srcData) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SM3", "BC");
        byte[] digest = messageDigest.digest(srcData);
        return digest;
    }
}

