/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.exception;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.lc.ibps.base.core.exception.BaseException;
import java.util.Collection;
import java.util.Map;

public class Assert {
    public static void isTrue(boolean expression, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (!expression) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
    }

    public static void isTrue(boolean expression, int state) throws BaseException {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true", state, new Object[0]);
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (expression) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
    }

    public static void isFalse(boolean expression, int state) throws BaseException {
        Assert.isFalse(expression, "[Assertion failed] - this expression must be false", state, new Object[0]);
    }

    public static void isNull(Object object, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (object != null) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
    }

    public static void isNull(Object object, int state) throws BaseException {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null", state, new Object[0]);
    }

    public static <T> T notNull(T object, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (object == null) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
        return object;
    }

    public static <T> T notNull(T object, int state) throws BaseException {
        return Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null", state, new Object[0]);
    }

    public static <T extends CharSequence> T notEmpty(T text, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (StrUtil.isEmpty(text)) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
        return text;
    }

    public static <T extends CharSequence> T notEmpty(T text, int state) throws BaseException {
        return Assert.notEmpty(text, "[Assertion failed] - this String argument must have length; it must not be null or empty", state, new Object[0]);
    }

    public static <T extends CharSequence> T notBlank(T text, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (StrUtil.isBlank(text)) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
        return text;
    }

    public static <T extends CharSequence> T notBlank(T text, int state) throws BaseException {
        return Assert.notBlank(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", state, new Object[0]);
    }

    public static Object[] notEmpty(Object[] array, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (ArrayUtil.isEmpty((Object[])array)) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
        return array;
    }

    public static Object[] notEmpty(Object[] array, int state) throws BaseException {
        return Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", state, new Object[0]);
    }

    public static <T> T[] noNullElements(T[] array, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (ArrayUtil.hasNull((Object[])array)) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array, int state) throws BaseException {
        return Assert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements", state, new Object[0]);
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (CollUtil.isEmpty(collection)) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
        return collection;
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection, int state) throws BaseException {
        return Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element", state, new Object[0]);
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map, String errorMsgTemplate, int state, Object ... params) throws BaseException {
        if (CollUtil.isEmpty(map)) {
            throw new BaseException(state, String.format(errorMsgTemplate, params), params);
        }
        return map;
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map, int state) throws BaseException {
        return Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry", state, new Object[0]);
    }
}

