/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.spring.annotation;

import com.lc.ibps.base.core.util.BeanUtils;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.core.Ordered;

public abstract class AbsMethodInterceptor
implements MethodInterceptor,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbsMethodInterceptor.class);
    protected boolean enabled = false;
    protected int order = 0;
    protected List<String> pointcut;
    protected List<String> excludePointcut;

    protected abstract String[] defExpression();

    protected abstract String[] defExcludes();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            Object ret = null;
            ret = this.before(invocation);
            if (!this.hasRtn()) {
                ret = invocation.proceed();
            } else if (BeanUtils.isEmpty(ret)) {
                ret = invocation.proceed();
            }
            this.after(invocation);
            return ret;
        }
        catch (Exception e) {
            this.thr(invocation, e);
            throw e;
        }
    }

    protected abstract boolean hasRtn();

    protected abstract Object before(MethodInvocation var1);

    protected abstract void after(MethodInvocation var1);

    protected abstract void thr(MethodInvocation var1, Exception var2);

    public Pointcut createPointcut() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        String pointcuts = this.createPointcutExpression();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Aspect JExpression Pointcut of {} is '{}'.", (Object)this.getClass().getSimpleName(), (Object)pointcuts);
        }
        pointcut.setExpression(pointcuts);
        return pointcut;
    }

    protected String createPointcutExpression() {
        StringJoiner includesJoiner = new StringJoiner(" || ");
        String[] pointcuts = this.defExpression();
        if (Objects.nonNull(this.pointcut) && this.pointcut.size() > 0) {
            pointcuts = this.pointcut.toArray(new String[0]);
        }
        for (String string : pointcuts) {
            includesJoiner.add(string);
        }
        String includes = includesJoiner.toString();
        StringJoiner excludesJoiner = new StringJoiner(" || ");
        String[] excludePointcuts = this.defExcludes();
        if (Objects.nonNull(this.excludePointcut) && this.excludePointcut.size() > 0) {
            excludePointcuts = this.excludePointcut.toArray(new String[0]);
        }
        if (BeanUtils.isNotEmpty(excludePointcuts)) {
            for (String pointcut : excludePointcuts) {
                excludesJoiner.add("!" + pointcut);
            }
            String string = excludesJoiner.toString();
            return "(" + includes + ")" + " && " + "(" + string + ")";
        }
        return includes;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(List<String> pointcut) {
        this.pointcut = pointcut;
    }

    public List<String> getExcludePointcut() {
        return this.excludePointcut;
    }

    public void setExcludePointcut(List<String> excludePointcut) {
        this.excludePointcut = excludePointcut;
    }
}

