/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.JacksonUtil;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class ConvertUtil {
    private static final ConfigurableConversionService conversionService = new DefaultConversionService();

    @Nullable
    public static <T> T convertValueIfNecessary(Object value, @Nullable Class<T> targetType) {
        if (targetType == null) {
            if (value == null) {
                return null;
            }
            return (T)value;
        }
        ConfigurableConversionService conversionServiceToUse = conversionService;
        if (conversionServiceToUse == null) {
            if (ClassUtils.isAssignableValue(targetType, (Object)value)) {
                return (T)value;
            }
            conversionServiceToUse = DefaultConversionService.getSharedInstance();
        }
        return (T)conversionServiceToUse.convert(value, targetType);
    }

    @Nullable
    public static <T> T convertValueIfNecessary(Object value, @Nullable Class<T> targetType, T defaultValue) {
        T t = ConvertUtil.convertValueIfNecessary(value, targetType);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public static Float convertToFloat(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Integer) {
            return new Float(((Integer)value).toString());
        }
        if (value instanceof Double) {
            return new Float(((Double)value).toString());
        }
        return null;
    }

    public static Map<String, Object> convertToMap(Object value) {
        if (BeanUtils.isEmpty(value)) {
            return null;
        }
        if (ClassUtils.isAssignableValue(Map.class, (Object)value)) {
            return (Map)value;
        }
        if (ClassUtils.isAssignableValue(String.class, (Object)value) && JacksonUtil.isJsonObject(value.toString())) {
            return JacksonUtil.toMap(value.toString());
        }
        return null;
    }

    public static List<Map> convertToMapList(Object value) {
        if (BeanUtils.isEmpty(value)) {
            return null;
        }
        if (ClassUtils.isAssignableValue(List.class, (Object)value)) {
            return (List)value;
        }
        if (ClassUtils.isAssignableValue(String.class, (Object)value) && JacksonUtil.isJsonArray(value.toString())) {
            return JacksonUtil.getDTOList(value.toString());
        }
        return null;
    }
}

