/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.EnvUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(I18nUtil.class);
    private static I18nUtil i18nUtil;
    private String property = "com.lc.messages.enabled";
    private boolean enabled;
    private MessageSource i18n;

    public I18nUtil init() {
        this.enabled = EnvUtil.getProperty(this.property, Boolean.class, Boolean.valueOf(true));
        this.i18n = (MessageSource)EnvUtil.getBean("messageSource");
        if (Objects.isNull(this.i18n)) {
            this.i18n = EnvUtil.getBean(MessageSource.class);
        }
        if (BeanUtils.isEmpty(this.i18n) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("MessageSource is null.");
        }
        i18nUtil = this;
        return this;
    }

    private static Locale getLocale() {
        if (I18nUtil.i18nUtil.enabled) {
            return LocaleContextHolder.getLocale();
        }
        return Locale.SIMPLIFIED_CHINESE;
    }

    public static Locale getLocale(String lang) {
        if (Objects.nonNull(lang)) {
            String[] split = lang.split("-");
            if (split != null && split.length == 2) {
                return new Locale(split[0], split[1]);
            }
            return new Locale(lang);
        }
        return Locale.SIMPLIFIED_CHINESE;
    }

    public static String getMessage(String code) {
        return I18nUtil.i18nUtil.i18n.getMessage(code, Collections.emptyList().toArray(), I18nUtil.getLocale());
    }

    public static String getMessage(String code, Object ... args) {
        return I18nUtil.i18nUtil.i18n.getMessage(code, Optional.ofNullable(args).orElse(Collections.emptyList().toArray()), I18nUtil.getLocale());
    }
}

