/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JAXBUtil {
    private static final Map<String, JAXBContext> LOCAL_CACHE = Maps.newConcurrentMap();

    private JAXBUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unmarshall(String xml, Class clsToUnbound) throws JAXBException, UnsupportedEncodingException {
        String cacheKey = clsToUnbound.getName();
        JAXBContext jc = null;
        Map<String, JAXBContext> map = LOCAL_CACHE;
        synchronized (map) {
            if (LOCAL_CACHE.containsKey(cacheKey)) {
                jc = LOCAL_CACHE.get(cacheKey);
            } else {
                jc = JAXBContext.newInstance((Class[])new Class[]{clsToUnbound});
                LOCAL_CACHE.put(cacheKey, jc);
            }
        }
        return JAXBUtil.unmarshall(jc, xml);
    }

    private static Object unmarshall(JAXBContext jc, String xml) throws JAXBException, UnsupportedEncodingException {
        Unmarshaller u = jc.createUnmarshaller();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        return u.unmarshal((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unmarshall(InputStream xmlIs, Class<?> cls) throws JAXBException {
        String cacheKey = cls.getName();
        JAXBContext jc = null;
        Map<String, JAXBContext> map = LOCAL_CACHE;
        synchronized (map) {
            if (LOCAL_CACHE.containsKey(cacheKey)) {
                jc = LOCAL_CACHE.get(cacheKey);
            } else {
                jc = JAXBContext.newInstance((Class[])new Class[]{cls});
                LOCAL_CACHE.put(cacheKey, jc);
            }
        }
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        return unmarshaller.unmarshal(xmlIs);
    }

    public Object unmarshall(String xml, Class<? extends Object>[] classes) throws JAXBException {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        JAXBContext jc = JAXBContext.newInstance((Class[])classes);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        return unmarshaller.unmarshal((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshall(Object pojo, Class clsToBound) throws JAXBException {
        String cacheKey = clsToBound.getName();
        JAXBContext jc = null;
        Map<String, JAXBContext> map = LOCAL_CACHE;
        synchronized (map) {
            if (LOCAL_CACHE.containsKey(cacheKey)) {
                jc = LOCAL_CACHE.get(cacheKey);
            } else {
                jc = JAXBContext.newInstance((Class[])new Class[]{clsToBound});
                LOCAL_CACHE.put(cacheKey, jc);
            }
        }
        return JAXBUtil.marshall(jc, pojo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshall(Object pojo, Class clsToBound, String charset) throws JAXBException {
        String cacheKey = clsToBound.getName();
        JAXBContext jc = null;
        Map<String, JAXBContext> map = LOCAL_CACHE;
        synchronized (map) {
            if (LOCAL_CACHE.containsKey(cacheKey)) {
                jc = LOCAL_CACHE.get(cacheKey);
            } else {
                jc = JAXBContext.newInstance((Class[])new Class[]{clsToBound});
                LOCAL_CACHE.put(cacheKey, jc);
            }
        }
        return JAXBUtil.marshall(jc, pojo, charset);
    }

    private static String marshall(JAXBContext jc, Object serObj) throws JAXBException {
        return JAXBUtil.marshall(jc, serObj, System.getProperty("file.encoding"));
    }

    private static String marshall(JAXBContext jc, Object serObj, String charset) throws JAXBException {
        StringWriter out = new StringWriter();
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)charset);
        m.marshal(serObj, (Writer)out);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void marshall(String contextPath, Object obj, OutputStream stream) throws JAXBException {
        JAXBContext jc = null;
        Map<String, JAXBContext> map = LOCAL_CACHE;
        synchronized (map) {
            if (LOCAL_CACHE.containsKey(contextPath)) {
                jc = LOCAL_CACHE.get(contextPath);
            } else {
                jc = JAXBContext.newInstance((String)contextPath);
                LOCAL_CACHE.put(contextPath, jc);
            }
        }
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.marshal(obj, stream);
    }
}

