/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.lc.ibps.base.core.thread.CustomRunnable;
import com.lc.ibps.base.core.thread.CustomThreadFactory;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class ScheduledUtil {
    public static final String DEFAULT_THREAD_GROUP_NAME = "ibps-thread";

    public static ThreadFactory getThreadFactory(String threadGroupName) {
        if (StringUtil.isBlank((CharSequence)threadGroupName)) {
            return ScheduledUtil.getThreadFactory();
        }
        return new CustomThreadFactory(threadGroupName);
    }

    public static ThreadFactory getThreadFactory() {
        return new CustomThreadFactory(DEFAULT_THREAD_GROUP_NAME);
    }

    public static void createAndRunningScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, long delay, long period, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        for (int idx = 0; idx < corePoolSize; ++idx) {
            pool.scheduleWithFixedDelay(new CustomRunnable(execution), delay, period, timeUnit);
        }
    }

    public static void createAndRunningScheduledThreadPoolExecutor(int corePoolSize, String threadGroupName, long delay, long period, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, ScheduledUtil.getThreadFactory(threadGroupName));
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        for (int idx = 0; idx < corePoolSize; ++idx) {
            pool.scheduleWithFixedDelay(new CustomRunnable(execution), delay, period, timeUnit);
        }
    }

    public static void createAndRunningScheduledThreadPoolExecutor(int corePoolSize, long delay, long period, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, ScheduledUtil.getThreadFactory());
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        for (int idx = 0; idx < corePoolSize; ++idx) {
            pool.scheduleWithFixedDelay(new CustomRunnable(execution), delay, period, timeUnit);
        }
    }

    public static void createAndRunningOnceThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, long delay, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        for (int idx = 0; idx < corePoolSize; ++idx) {
            pool.schedule(new CustomRunnable(execution), delay, timeUnit);
        }
    }

    public static void createAndRunningOnceThreadPoolExecutor(int corePoolSize, String threadGroupName, long delay, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, ScheduledUtil.getThreadFactory(threadGroupName));
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        for (int idx = 0; idx < corePoolSize; ++idx) {
            pool.schedule(new CustomRunnable(execution), delay, timeUnit);
        }
    }

    public static void createAndRunningOnceThreadPoolExecutor(int corePoolSize, long delay, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, ScheduledUtil.getThreadFactory());
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        for (int idx = 0; idx < corePoolSize; ++idx) {
            pool.schedule(new CustomRunnable(execution), delay, timeUnit);
        }
    }
}

