/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class ThreadUtil {
    public static final int DEFAULT_THREAD_COUNT = 100;
    public static final int THREAD_TYPE_DEFAULT = 3;
    public static final int THREAD_TYPE_SINGLE = 1;
    public static final int THREAD_TYPE_FIXED = 2;
    public static final int THREAD_TYPE_CACHED = 3;
    private static ExecutorService singleThreadExecutor = null;
    private static ExecutorService fixedThreadPool = null;
    private static ExecutorService cachedThreadPool = null;

    private ThreadUtil() {
    }

    public static void initSingleThreadExecutor() {
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(ThreadUtil.class.getSimpleName() + "-Single-DefaultThread-");
        singleThreadExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
    }

    public static void initFixedThreadPool(int nThreads) {
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(ThreadUtil.class.getSimpleName() + "-Fixed-DefaultThread-");
        fixedThreadPool = new ThreadPoolExecutor(0, nThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
    }

    public static void initCachedThreadPool() {
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(ThreadUtil.class.getSimpleName() + "-Fixed-DefaultThread-");
        cachedThreadPool = new ThreadPoolExecutor(4, 64, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
    }

    public static void execute(int type, Runnable runnable) {
        switch (type) {
            case 1: {
                if (null == singleThreadExecutor) {
                    ThreadUtil.initSingleThreadExecutor();
                }
                singleThreadExecutor.execute(runnable);
                break;
            }
            case 2: {
                if (null == fixedThreadPool) {
                    ThreadUtil.initFixedThreadPool(100);
                }
                fixedThreadPool.execute(runnable);
                break;
            }
            case 3: {
                if (null == cachedThreadPool) {
                    ThreadUtil.initCachedThreadPool();
                }
                cachedThreadPool.execute(runnable);
                break;
            }
            default: {
                if (null == singleThreadExecutor) {
                    ThreadUtil.initSingleThreadExecutor();
                }
                singleThreadExecutor.execute(runnable);
            }
        }
    }
}

