/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.lc.ibps.base.core.thread.DateFormatThreadUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;

public class DateJsonDeserializer
extends JsonDeserializer<Date> {
    private String dateFormat;

    public DateJsonDeserializer(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Date deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JacksonException {
        String dateString = jsonParser.getText();
        try {
            return DateFormatThreadUtil.get(this.dateFormat).parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse date: " + dateString, e);
        }
    }
}

