/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util.string;

import com.lc.ibps.base.core.entity.OptionEntity;
import com.lc.ibps.base.core.util.string.StringConverter;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.ArrayUtils;

public class StringCollections {
    private StringCollections() {
    }

    public static final String[] toArray(String stringWithToken, String token) {
        String[] array = null;
        if (stringWithToken != null && stringWithToken.length() > 0 && token != null && token.length() > 0) {
            if (stringWithToken.indexOf(token) > -1) {
                StringTokenizer st = new StringTokenizer(stringWithToken, token);
                if (st.countTokens() > 0) {
                    array = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        array[i++] = st.nextToken();
                    }
                }
            } else {
                array = new String[]{stringWithToken};
            }
        }
        return array;
    }

    public static final String[] toArray(String stringWithComma) {
        return StringCollections.toArray(stringWithComma, ",");
    }

    public static final String[] toArray(List<String> list) {
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static final List<String> toListNoToken(String letters) {
        ArrayList<String> singles = new ArrayList<String>();
        if (StringUtil.isNotEmpty((CharSequence)letters)) {
            for (int i = 0; i < letters.length(); ++i) {
                singles.add(letters.substring(i, i + 1));
            }
        }
        return singles;
    }

    public static final List<String> toList(String str, String token) {
        ArrayList<String> array = new ArrayList<String>();
        if (str != null && str.length() > 0 && token != null && token.length() > 0) {
            if (str.indexOf(token) > -1) {
                StringTokenizer st = new StringTokenizer(str, token);
                while (st.hasMoreTokens()) {
                    array.add(st.nextToken());
                }
            } else {
                array.add(str);
            }
        }
        return array;
    }

    public static final List<OptionEntity> toOptionList(String str, String token, String optionToken) {
        List<String> options = StringCollections.toList(str, token);
        ArrayList<OptionEntity> optionEntities = new ArrayList<OptionEntity>();
        for (String option : options) {
            OptionEntity optionEntity = new OptionEntity(option, optionToken);
            optionEntities.add(optionEntity);
        }
        return optionEntities;
    }

    public static final List<Integer> toListInteger(String str, String token) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (str != null && str.length() > 0 && token != null && token.length() > 0) {
            if (str.indexOf(token) > -1) {
                StringTokenizer st = new StringTokenizer(str, token);
                while (st.hasMoreTokens()) {
                    array.add(StringConverter.toInteger(st.nextToken()));
                }
            } else {
                array.add(new Integer(str));
            }
        }
        return array;
    }

    public static final List<Long> toListLong(String str, String token) {
        ArrayList<Long> array = new ArrayList<Long>();
        if (str != null && str.length() > 0 && token != null && token.length() > 0) {
            if (str.indexOf(token) > -1) {
                StringTokenizer st = new StringTokenizer(str, token);
                while (st.hasMoreTokens()) {
                    array.add(StringConverter.toLong(st.nextToken()));
                }
            } else {
                array.add(new Long(str));
            }
        }
        return array;
    }

    public static final Map<String, String> toMap(String options, String tokenEntry, String tokenKeyAndValue) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[] strArray = StringCollections.toArray(options, tokenEntry);
        if (null == strArray) {
            return map;
        }
        for (int i = 0; i < strArray.length; ++i) {
            String option = strArray[i];
            if (option.indexOf(tokenKeyAndValue) > -1) {
                String[] keyAndValue = StringCollections.toArray(option, tokenKeyAndValue);
                if (null == keyAndValue) continue;
                map.put(keyAndValue[0], keyAndValue[1]);
                continue;
            }
            map.put(option, option);
        }
        return map;
    }

    public static final String toString(Collection<String> objs) {
        return StringCollections.toString(objs, ",");
    }

    public static final String toString(Collection<String> objs, String appendToken) {
        return StringCollections.toString(objs, appendToken, "");
    }

    public static final String toString(Collection<String> objs, String appendToken, String appendPrefix) {
        if (objs == null || objs.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        Iterator<String> it = objs.iterator();
        while (it.hasNext()) {
            str.append(appendPrefix).append((Object)it.next()).append(appendToken);
        }
        return str.substring(0, str.length() - appendToken.length());
    }

    public static final String toString(String[] stringArray, String appendToken) {
        if (ArrayUtils.isEmpty((Object[])stringArray)) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            str.append(stringArray[i]).append(appendToken);
        }
        return str.substring(0, str.length() - appendToken.length());
    }
}

