/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util.string;

import cn.hutool.core.text.StrSplitter;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringValidator {
    private static Logger logger = LoggerFactory.getLogger(StringValidator.class);
    public static final String SPECIAL = "[`~!#$^&*|\\[\\]'+<>=?!/\\\\]";
    public static final String ESCAPE = "[-_']";

    private StringValidator() {
    }

    public static boolean isNumberic(String s) {
        boolean rtn = StringValidator.valid("^[-+]{0,1}\\d*\\.{0,1}\\d+$", s);
        if (rtn) {
            return true;
        }
        return StringValidator.valid("^0[x|X][\\da-eA-E]+$", s);
    }

    public static boolean isInteger(String s) {
        return StringValidator.valid("^[-+]{0,1}\\d*$", s);
    }

    public static boolean isEmail(String s) {
        return StringValidator.valid("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$", s);
    }

    public static boolean isMobile(String s) {
        return StringValidator.valid("^(((1[3-9]{1}[0-9]{1}))\\d{8})$", s);
    }

    public static boolean isPhone(String s) {
        return StringValidator.valid("^((\\(0[0-9]{2,3}\\))|(0[0-9]{2,3})\\-)?([2-9][0-9]{6,7})(\\-[0-9]{1,4})?$", s);
    }

    public static boolean isZip(String s) {
        return StringValidator.valid("^[0-9]{6}$", s);
    }

    public static boolean isIDCard(String s) {
        return StringValidator.valid("(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)", s);
    }

    public static boolean isQq(String s) {
        return StringValidator.valid("^[1-9]\\d{4,9}$", s);
    }

    public static boolean isIp(String s) {
        return StringValidator.valid("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$", s);
    }

    public static boolean isChinese(String s) {
        return StringValidator.valid("^[\u4e00-\u9fa5]+$", s);
    }

    public static boolean isChrNum(String s) {
        return StringValidator.valid("^([a-zA-Z0-9]+)$", s);
    }

    public static boolean isUrl(String url) {
        return StringValidator.valid("(http://|https://)?([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?", url);
    }

    public static boolean isZeroEmpty(String str) {
        boolean isEmpty = StringUtil.isEmpty((CharSequence)str);
        if (isEmpty) {
            return true;
        }
        return "0".equals(str);
    }

    public static boolean isRoundNumber(String s) {
        return StringValidator.valid("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$", s);
    }

    public static boolean valid(String regex, String input) {
        if (StringUtil.isEmpty((CharSequence)regex)) {
            return false;
        }
        Pattern p = Pattern.compile(regex, 2);
        Matcher regexMatcher = p.matcher(input);
        return regexMatcher.find();
    }

    public static boolean isMatchWholeUrl(String url, String ... urls) {
        HashSet<String> urlsSet = new HashSet<String>(Arrays.asList(urls));
        return StringValidator.isMatchWholeUrl(url, urlsSet);
    }

    public static boolean isMatchWholeUrl(String url, List<String> urls) {
        HashSet<String> urlsSet = new HashSet<String>(urls);
        return StringValidator.isMatchWholeUrl(url, urlsSet);
    }

    public static boolean isMatchWholeUrl(String url, Set<String> urls) {
        return urls.contains(url);
    }

    public static boolean isMatchUrl(String url, String ... urls) {
        HashSet<String> urlsSet = new HashSet<String>(Arrays.asList(urls));
        return StringValidator.isMatchUrl(url, urlsSet);
    }

    public static boolean isMatchUrl(String url, List<String> urls) {
        HashSet<String> urlsSet = new HashSet<String>(urls);
        return StringValidator.isMatchUrl(url, urlsSet);
    }

    public static boolean isMatchUrl(String url, Set<String> urls) {
        boolean is = StringValidator.isMatchWholeUrl(url, urls);
        if (is) {
            if (logger.isDebugEnabled()) {
                logger.debug("primary url: {} match {}.", (Object)url, (Object)url);
            }
            return true;
        }
        return StringValidator.isMatchUrlReg(url, urls);
    }

    public static boolean isMatchUrlReg(String url, String ... urls) {
        HashSet<String> urlsSet = new HashSet<String>(Arrays.asList(urls));
        return StringValidator.isMatchUrlReg(url, urlsSet);
    }

    public static boolean isMatchUrlReg(String url, List<String> urls) {
        HashSet<String> urlsSet = new HashSet<String>(urls);
        return StringValidator.isMatchUrlReg(url, urlsSet);
    }

    public static boolean isMatchUrlReg(String url, Set<String> urls) {
        String patternVariable = "^\\{[\\S]+\\}$";
        String patternVariableAny = "^[\\*]{1}$";
        String patternAny = "^[\\*]{2,}$";
        String patternDirect1 = "[a-zA-Z0-9\\.\\_\\-]+";
        String patternDirectN = "([a-zA-Z0-9\\.\\_\\-]+[/a-zA-Z0-9\\.\\_\\-]*)";
        for (String urlItem : urls) {
            Object[] urlItemArray = StrSplitter.splitPathToArray((CharSequence)urlItem);
            for (int i = 0; i < urlItemArray.length; ++i) {
                String urlItemArrayItem = urlItemArray[i];
                if (StringValidator.valid(patternVariable, urlItemArrayItem) || StringValidator.valid(patternVariableAny, urlItemArrayItem)) {
                    urlItemArray[i] = patternDirect1;
                    continue;
                }
                if (!StringValidator.valid(patternAny, urlItemArrayItem)) continue;
                urlItemArray[i] = patternDirectN;
            }
            String patternUrl = StringUtil.build("^/", StringUtil.join((Object[])urlItemArray, (String)"/"), "$");
            patternUrl = patternUrl.replaceAll("}/", "}");
            boolean isMatch = StringValidator.valid(patternUrl, url);
            if (logger.isTraceEnabled()) {
                logger.trace("url {} and pattern {} is {} match.", new Object[]{url, patternUrl, isMatch ? "" : "not"});
            }
            if (!isMatch) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("primary url: {} match {}.", (Object)url, (Object)urlItem);
            }
            return true;
        }
        return false;
    }
}

