/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util.time;

import cn.hutool.core.date.DateTime;
import com.lc.ibps.base.core.exception.BaseException;
import com.lc.ibps.base.core.thread.DateFormatThreadUtil;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.optional.Pair;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.base.core.util.string.StringValidator;
import com.lc.ibps.base.core.util.time.DateUtil;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatUtil {
    private static Logger logger = LoggerFactory.getLogger(DateFormatUtil.class);

    private DateFormatUtil() {
    }

    public static java.util.Date parse(String dateString) {
        return DateFormatUtil.parse(dateString, 946656000000L);
    }

    public static java.util.Date parse(String dateString, Long compare) {
        if (dateString == null) {
            return null;
        }
        if (StringValidator.isNumberic(dateString) && Long.valueOf(dateString) > compare) {
            DateTime dateTime = cn.hutool.core.date.DateUtil.date((long)Long.valueOf(dateString));
            return dateTime.toJdkDate();
        }
        String[] styles = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH", "yyyy-MM-dd", "yyyy-MM", "HH:mm:ss", "HH:mm", "yyyy"};
        Pair<Boolean, java.util.Date> pair = DateFormatUtil.parsePair(dateString, styles);
        if (pair.getFirst().booleanValue()) {
            return pair.getSecond();
        }
        throw new BaseException(6010116, String.format("\u65e5\u671f[%s]\u4e0d\u652f\u6301", dateString), dateString);
    }

    public static java.util.Date parse(String dateString, String style) throws ParseException {
        return DateUtils.parseDate((String)dateString, (String[])new String[]{style});
    }

    public static String format(Object date) {
        if (BeanUtils.isEmpty(date)) {
            return "";
        }
        if (date instanceof Timestamp) {
            return DateFormatThreadUtil.get("yyyy-MM-dd HH:mm:ss.SSS").format(date);
        }
        if (date instanceof Time) {
            return DateFormatThreadUtil.get("HH:mm:ss").format(date);
        }
        if (date instanceof Date) {
            return DateFormatThreadUtil.get("yyyy-MM-dd").format(date);
        }
        return DateFormatThreadUtil.get("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static java.util.Date parse(String dateString, String ... style) {
        java.util.Date date = null;
        if (StringUtil.isEmpty((CharSequence)dateString)) {
            return date;
        }
        try {
            date = DateUtils.parseDate((String)dateString, (String[])style);
        }
        catch (Exception e) {
            logger.error("Parse the date(" + dateString + ") occur errors:" + e.getMessage());
        }
        return date;
    }

    public static Pair<Boolean, java.util.Date> parsePair(String dateString, String ... style) {
        if (StringUtil.isBlank((CharSequence)dateString)) {
            return Pair.of(true, null);
        }
        java.util.Date date = null;
        int error = 0;
        for (String sty : style) {
            try {
                if (!sty.contains("y")) {
                    java.util.Date date0 = DateUtil.parseWithoutYear(dateString, sty);
                    if (BeanUtils.isNotEmpty(date0)) {
                        date = date0;
                        break;
                    }
                    throw new BaseException();
                }
                date = DateUtils.parseDate((String)dateString, (String[])new String[]{sty});
            }
            catch (Exception e) {
                ++error;
                logger.debug("Parse the date(" + dateString + ") occur errors:" + e.getMessage());
            }
        }
        return Pair.of(error != style.length, date);
    }

    public static String format(java.util.Date date, String style) {
        return DateFormatUtils.format((java.util.Date)date, (String)style);
    }

    public static java.util.Date parseDate(String dateString) throws ParseException {
        return DateFormatThreadUtil.get("yyyy-MM-dd").parse(dateString);
    }

    public static String formatDate(java.util.Date date) {
        return DateFormatThreadUtil.get("yyyy-MM-dd").format(date);
    }

    public static java.util.Date parseDateTime(String dateString) throws ParseException {
        return DateFormatThreadUtil.get("yyyy-MM-dd HH:mm:ss").parse(dateString);
    }

    public static String formatDateTime(java.util.Date date) {
        return DateFormatThreadUtil.get("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String formatTimeNoSecond(java.util.Date date) {
        return DateFormatThreadUtil.get("yyyy-MM-dd HH:mm").format(date);
    }

    public static java.util.Date parseTimeNoSecond(String dateString) throws ParseException {
        return DateFormatThreadUtil.get("yyyy-MM-dd HH:mm").parse(dateString);
    }

    public static String format(long millisecond) {
        java.util.Date date = new java.util.Date(millisecond);
        return DateFormatUtil.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(long millisecond, String style) {
        java.util.Date date = new java.util.Date(millisecond);
        return DateFormatUtil.format(date, style);
    }

    public static String getCurrentTime() {
        return DateFormatUtil.getCurrentTime(null);
    }

    public static String getCurrentDate() {
        return DateFormatUtil.formatDate(new java.util.Date());
    }

    public static String getNowYMD() {
        return DateFormatThreadUtil.get("yyyyMMdd").format(new java.util.Date());
    }

    public static String getNowYM() {
        return DateFormatThreadUtil.get("yyyyMM").format(new java.util.Date());
    }

    public static String getNowY() {
        return DateFormatThreadUtil.get("yyyy").format(new java.util.Date());
    }

    public static String getNowPart(String format) {
        return DateFormatUtils.format((java.util.Date)new java.util.Date(), (String)format);
    }

    public static String getCurrentTime(String style) {
        if (StringUtil.isEmpty((CharSequence)style)) {
            style = "yyyy-MM-dd HH:mm:ss";
        }
        return DateFormatUtil.format(new java.util.Date(), style);
    }
}

