/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util.time;

import com.lc.ibps.base.core.util.string.StringUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import org.springframework.data.util.Pair;

public class DurationUtil {
    public static Pair<String, Long> createPair(LocalDateTime start) {
        Duration duration = Duration.between(start, LocalDateTime.now());
        return DurationUtil.createPair(duration);
    }

    public static Pair<String, Long> createPair(LocalDateTime start, LocalDateTime end) {
        Duration duration = Duration.between(start, end);
        return DurationUtil.createPair(duration);
    }

    public static Pair<String, Long> createPair(Duration duration) {
        long smillis = duration.toMillis();
        long minutes = smillis / 1000L / 60L;
        long seconds = smillis / 1000L % 60L;
        long millis = smillis % 1000L;
        String first = StringUtil.build(minutes, "'m ", seconds, "'s ", millis, "'ms");
        return Pair.of((Object)first, (Object)smillis);
    }

    public static String createStr(LocalDateTime start) {
        Duration duration = Duration.between(start, LocalDateTime.now());
        return DurationUtil.createStr(duration);
    }

    public static String createStr(LocalDateTime start, LocalDateTime end) {
        Duration duration = Duration.between(start, end);
        return DurationUtil.createStr(duration);
    }

    public static String createStr(Duration duration) {
        long smillis = duration.toMillis();
        long minutes = smillis / 1000L / 60L;
        long seconds = smillis / 1000L % 60L;
        long millis = smillis % 1000L;
        return StringUtil.build(minutes, "'m ", seconds, "'s ", millis, "'ms");
    }
}

