/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.lc.ibps.base.core.context.DefaultThreadContext;
import com.lc.ibps.base.core.context.ThreadContext;
import com.lc.ibps.base.core.util.EnvUtil;
import com.lc.ibps.base.core.util.I18nUtil;
import com.lc.ibps.base.core.util.JacksonUtil;
import com.lc.ibps.base.core.util.ThreadContextUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@ConditionalOnProperty(prefix="com.lc.core", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class AutoConfigure {
    @Bean
    @DependsOn(value={"defaultThreadContext"})
    public EnvUtil envUtil() {
        return new EnvUtil();
    }

    @Bean
    @ConditionalOnMissingBean(value={ThreadContext.class})
    public ThreadContext defaultThreadContext() {
        return new DefaultThreadContext();
    }

    @Bean(initMethod="init")
    @DependsOn(value={"envUtil"})
    public ThreadContextUtil threadContextUtil() {
        return new ThreadContextUtil();
    }

    @Bean(initMethod="init")
    @DependsOn(value={"envUtil"})
    public I18nUtil i18nUtil() {
        return new I18nUtil();
    }

    @Bean
    @DependsOn(value={"threadContextUtil"})
    public ObjectMapper objectMapper(Module defaultModule) {
        boolean threadable = EnvUtil.getProperty("com.lc.ibps.jackson.thread.enabled", Boolean.class, Boolean.valueOf(false));
        JacksonUtil.setThreadable(threadable);
        boolean dateable = EnvUtil.getProperty("com.lc.ibps.jackson.date.enabled", Boolean.class, Boolean.valueOf(false));
        JacksonUtil.setDateable(dateable);
        ObjectMapper mapper = JacksonUtil.mapper(defaultModule);
        JacksonUtil.setMapper(mapper);
        return mapper;
    }

    @Bean
    @ConditionalOnMissingBean(value={Module.class})
    public Module defaultModule() {
        SimpleModule module = new SimpleModule();
        DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(localDateTimeFormatter));
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(localDateTimeFormatter));
        DateTimeFormatter localDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        module.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(localDateFormatter));
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(localDateFormatter));
        DateTimeFormatter localTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        module.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(localTimeFormatter));
        module.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(localTimeFormatter));
        return module;
    }
}

