/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.alarm;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailUtil;
import com.lc.ibps.base.core.alarm.AlarmConfig;
import com.lc.ibps.base.core.config.BaseMailProperties;
import com.lc.ibps.base.core.util.EnvUtil;
import com.lc.ibps.base.core.util.time.DateUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmUtil {
    private static final Logger logger = LoggerFactory.getLogger(AlarmUtil.class);

    public static AlarmConfig createConfig(boolean alarmEnabled, double threshold, int holdMinutes, int intervalMinutes) {
        return new AlarmConfig(alarmEnabled, threshold, holdMinutes, intervalMinutes);
    }

    public static void alarm(BaseMailProperties mailProperties, AlarmConfig alarmConfig, int max, int current, Date now, String subject, String content) {
        block10: {
            boolean isAlarm;
            double div = (double)current / ((double)max * 1.0);
            boolean alarm = div >= alarmConfig.getThreshold();
            alarmConfig.addAlarm(alarm);
            boolean isNeed = alarmConfig.getAlarm().size() == alarmConfig.getHoldMinutes() * 60;
            boolean bl = isAlarm = !alarmConfig.getAlarm().contains(false);
            if (alarmConfig.isAlarmEnabled() && isNeed && isAlarm) {
                boolean isAlarm0 = false;
                Date preAlarmDate = alarmConfig.getPreAlarmDate();
                if (Objects.isNull(preAlarmDate)) {
                    alarmConfig.setPreAlarmDate(now);
                    isAlarm0 = true;
                } else {
                    int intervalMinutes = alarmConfig.getIntervalMinutes();
                    Date preAlarmDatePlus = DateUtil.add(preAlarmDate, 12, intervalMinutes);
                    if (DateTime.of((Date)preAlarmDatePlus).isBefore(now)) {
                        alarmConfig.setPreAlarmDate(now);
                        isAlarm0 = true;
                    }
                }
                if (isAlarm0) {
                    MailAccount mailAccount = new MailAccount();
                    mailAccount.setHost(mailProperties.getHost());
                    mailAccount.setPort(Integer.valueOf(mailProperties.getPort()));
                    mailAccount.setFrom(mailProperties.getMailAddress());
                    mailAccount.setUser(mailProperties.getUsername());
                    mailAccount.setPass(mailProperties.getPassword());
                    mailAccount.setCharset(CharsetUtil.charset((String)mailProperties.getDefaultEncoding()));
                    mailAccount.setSslEnable(EnvUtil.getProperty("mail.smtp.ssl.enable", Boolean.class));
                    String hookNotifyTos = mailProperties.getNotifyTo();
                    if (StrUtil.isBlank((CharSequence)hookNotifyTos)) {
                        return;
                    }
                    List<String> hookNotifyToList = AlarmUtil.splitAddress(hookNotifyTos);
                    if (logger.isInfoEnabled()) {
                        for (String hookNotifyTo : hookNotifyToList) {
                            logger.info("Alarm notify to email {}!", (Object)hookNotifyTo);
                        }
                    }
                    try {
                        MailUtil.send((MailAccount)mailAccount, hookNotifyToList, (String)subject, (String)content, (boolean)false, (File[])new File[0]);
                    }
                    catch (Exception warn) {
                        if (!logger.isWarnEnabled()) break block10;
                        logger.warn("{}", (Object)warn.getMessage());
                    }
                }
            }
        }
    }

    private static List<String> splitAddress(String addresses) {
        if (StrUtil.isBlank((CharSequence)addresses)) {
            return null;
        }
        List result = StrUtil.contains((CharSequence)addresses, (char)',') ? StrUtil.splitTrim((CharSequence)addresses, (char)',') : (StrUtil.contains((CharSequence)addresses, (char)';') ? StrUtil.splitTrim((CharSequence)addresses, (char)';') : CollUtil.newArrayList((Object[])new String[]{addresses}));
        return result;
    }
}

