/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.encrypt;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.symmetric.AES;
import com.lc.ibps.base.core.config.EncryptConfig;
import com.lc.ibps.base.core.encrypt.AESUtil;
import com.lc.ibps.base.core.encrypt.Base64;
import com.lc.ibps.base.core.encrypt.IEncryptService;
import com.lc.ibps.base.core.encrypt.RSAUtil;
import com.lc.ibps.base.core.encrypt.SM2Util;
import com.lc.ibps.base.core.encrypt.SM4Util;
import com.lc.ibps.base.core.exception.BaseException;
import com.lc.ibps.base.core.util.EnvUtil;
import com.lc.ibps.base.core.util.FileUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

public class EncryptUtil {
    private static final String DEFAULT_KEY = "@#$%^6a7";
    private static final String KEY_ALGORITHM = "DES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";

    private EncryptUtil() {
    }

    public static String encryptMd5(String inStr) {
        return EncryptUtil.encryptMd5(inStr.getBytes());
    }

    public static String encryptMd5(byte[] bytes) {
        return DigestUtils.md5Hex((byte[])bytes);
    }

    public static String encryptFileMd5(String fileName) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(fileName);
        return EncryptUtil.encryptMd5(is);
    }

    public static String encryptMd5(InputStream is) {
        return EncryptUtil.encryptMd5(FileUtil.readByte(is));
    }

    public static String encryptFileMd5(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)out);
        return EncryptUtil.encryptMd5(out.toByteArray());
    }

    public static synchronized String encryptSha256(String inputStr) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(inputStr.getBytes("UTF-8"));
            return new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])digest));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    public static String decrypt(String message, String key) {
        String result = "";
        try {
            byte[] bytesrc = EncryptUtil.stringToBytes(message);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            DESKeySpec desKeySpec = new DESKeySpec(key.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_ALGORITHM);
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes("UTF-8"));
            cipher.init(2, (Key)secretKey, iv);
            byte[] retByte = cipher.doFinal(bytesrc);
            result = new String(retByte, "UTF-8");
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public static String decrypt(String message) {
        return EncryptUtil.decrypt(message, DEFAULT_KEY);
    }

    public static String encrypt(String message, String key) {
        byte[] retByte = new byte[]{};
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            DESKeySpec desKeySpec = new DESKeySpec(key.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_ALGORITHM);
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes("UTF-8"));
            cipher.init(1, (Key)secretKey, iv);
            retByte = cipher.doFinal(message.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), e.getCause());
        }
        return EncryptUtil.bytesToString(retByte);
    }

    public static String encrypt(String message) {
        return EncryptUtil.encrypt(message, DEFAULT_KEY);
    }

    public static byte[] stringToBytes(String temp) {
        byte[] digest = new byte[temp.length() / 2];
        for (int i = 0; i < digest.length; ++i) {
            String byteString = temp.substring(2 * i, 2 * i + 2);
            int byteValue = Integer.parseInt(byteString, 16);
            digest[i] = (byte)byteValue;
        }
        return digest;
    }

    public static String bytesToString(byte[] b) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String plainText = Integer.toHexString(0xFF & b[i]);
            if (plainText.length() < 2) {
                plainText = StringUtil.build("0", plainText);
            }
            hexString.append(plainText);
        }
        return hexString.toString();
    }

    public static String encryptData(String originData) {
        return EncryptUtil.encryptPassword(originData);
    }

    public static String encryptPassword(String originData) {
        EncryptConfig cryptConfig = EncryptUtil.getCryptConfig();
        if (!cryptConfig.isEncrypt()) {
            return originData;
        }
        String encryptName = cryptConfig.getEncryptName();
        String primaryKey = cryptConfig.getPrivateKey();
        String publicKey = cryptConfig.getPublicKey();
        String ivKey = cryptConfig.getIvKey();
        return EncryptUtil.encryptPassword(originData, encryptName, primaryKey, publicKey, ivKey);
    }

    public static String encryptData(String originData, String encryptName, String primaryKey, String publicKey, String ivKey) {
        return EncryptUtil.encryptPassword(originData, encryptName, primaryKey, publicKey, ivKey);
    }

    public static String encryptPassword(String originData, String encryptName, String primaryKey, String publicKey, String ivKey) {
        String data = originData;
        if ("base64".equalsIgnoreCase(encryptName)) {
            try {
                data = originData = Base64.encodeBase64(originData);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("\u5b57\u7b26\u96c6\u4e0d\u652f\u6301");
            }
        }
        if ("aes".equalsIgnoreCase(encryptName)) {
            try {
                data = originData = AESUtil.encrypt(originData, primaryKey, ivKey);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ("haes".equalsIgnoreCase(encryptName)) {
            AES aes = AESUtil.createAES(primaryKey, ivKey);
            data = originData = aes.encryptHex(originData);
        } else {
            if ("rsa".equalsIgnoreCase(encryptName)) {
                try {
                    data = originData = RSAUtil.encrypt(data, RSAUtil.getPublicKey(publicKey));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if ("hrsa".equalsIgnoreCase(encryptName)) {
                RSA rsa = RSAUtil.createRSA(primaryKey, publicKey);
                byte[] dataArr = rsa.encrypt(originData, KeyType.PublicKey);
                data = originData = cn.hutool.core.codec.Base64.encode((byte[])dataArr);
            } else {
                if ("rsa512".equalsIgnoreCase(encryptName)) {
                    try {
                        data = originData = RSAUtil.encrypt2048(data, RSAUtil.getPublicKey(publicKey));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if ("jrsa512".equalsIgnoreCase(encryptName)) {
                    try {
                        data = originData = RSAUtil.encrypt2048ByNimbusJoseJwt(data, RSAUtil.getPublicKey(publicKey));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if ("sm2".equalsIgnoreCase(encryptName)) {
                    try {
                        data = originData = SM2Util.encrypt(data, publicKey);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if ("sm4".equalsIgnoreCase(encryptName)) {
                    try {
                        data = originData = SM4Util.encrypt(data, primaryKey, ivKey);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    IEncryptService encryptService = (IEncryptService)Class.forName(encryptName).newInstance();
                    data = originData = encryptService.encrypt(data);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u52a0\u5bc6\u7b56\u7565[" + encryptName + "]\u4e0d\u652f\u6301\uff0c\u9700\u8981\u5b9e\u73b0\u63a5\u53e3[com.lc.ibps.base.core.encrypt.IEncryptService]", e);
                }
            }
        }
        return data;
    }

    public static String decryptData(String originData) {
        return EncryptUtil.decryptPassword(originData);
    }

    public static String decryptPassword(String originData) {
        EncryptConfig cryptConfig = EncryptUtil.getCryptConfig();
        if (!cryptConfig.isEncrypt()) {
            return originData;
        }
        String encryptName = cryptConfig.getEncryptName();
        String primaryKey = cryptConfig.getPrivateKey();
        String publicKey = cryptConfig.getPublicKey();
        String ivKey = cryptConfig.getIvKey();
        return EncryptUtil.decryptPassword(originData, encryptName, primaryKey, publicKey, ivKey);
    }

    public static String decryptData(String originData, String encryptName, String primaryKey, String publicKey, String ivKey) {
        return EncryptUtil.decryptPassword(originData, encryptName, primaryKey, publicKey, ivKey);
    }

    public static String decryptPassword(String originData, String encryptName, String primaryKey, String publicKey, String ivKey) {
        String data = originData;
        if ("base64".equalsIgnoreCase(encryptName)) {
            try {
                data = originData = Base64.decodeBase64(originData);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("\u5b57\u7b26\u96c6\u4e0d\u652f\u6301");
            }
        }
        if ("aes".equalsIgnoreCase(encryptName)) {
            try {
                data = originData = AESUtil.decrypt(originData, primaryKey, ivKey);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ("haes".equalsIgnoreCase(encryptName)) {
            AES aes = AESUtil.createAES(primaryKey, ivKey);
            data = originData = aes.decryptStr(originData);
        } else {
            if ("rsa".equalsIgnoreCase(encryptName)) {
                try {
                    data = originData = RSAUtil.decrypt(originData, RSAUtil.getPrivateKey(primaryKey));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if ("hrsa".equalsIgnoreCase(encryptName)) {
                RSA rsa = RSAUtil.createRSA(primaryKey, publicKey);
                byte[] decrypt = rsa.decrypt(originData, KeyType.PrivateKey);
                data = originData = StrUtil.utf8Str((Object)decrypt);
            } else {
                if ("rsa512".equalsIgnoreCase(encryptName)) {
                    try {
                        data = originData = RSAUtil.decrypt2048(originData, RSAUtil.getPrivateKey(primaryKey));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if ("jrsa512".equalsIgnoreCase(encryptName)) {
                    try {
                        data = originData = RSAUtil.decrypt2048ByNimbusJoseJwt(originData, RSAUtil.getPrivateKey(primaryKey));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if ("sm2".equalsIgnoreCase(encryptName)) {
                    try {
                        data = originData = SM2Util.decrypt(originData, primaryKey);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if ("sm4".equalsIgnoreCase(encryptName)) {
                    try {
                        data = originData = SM4Util.decrypt(originData, primaryKey, ivKey);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    IEncryptService encryptService = (IEncryptService)Class.forName(encryptName).newInstance();
                    data = originData = encryptService.decrypt(originData);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u52a0\u5bc6\u7b56\u7565[" + encryptName + "]\u4e0d\u652f\u6301\uff0c\u9700\u8981\u5b9e\u73b0\u63a5\u53e3[com.lc.ibps.base.core.encrypt.IEncryptService]", e);
                }
            }
        }
        return data;
    }

    private static EncryptConfig getCryptConfig() {
        return EnvUtil.getBean(EncryptConfig.class);
    }
}

