/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.encrypt;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SecureUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;

public class SM2Util {
    private static final Logger log = LoggerFactory.getLogger(SM2Util.class);
    private static final String GM_NAMED = "sm2p256v1";
    private static final String SECURE_RANDOM = "SHA1PRNG";
    private static final X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static final ECDomainParameters ecDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static final ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());

    public static String encrypt(String data, String publicKey) throws Exception {
        byte[] plainText = data.getBytes();
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        ECPoint pukPoint = x9ECParameters.getCurve().decodePoint(Hex.decode((String)publicKey));
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(pukPoint, ecDomainParameters);
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, SecureRandom.getInstance(SECURE_RANDOM)));
        byte[] cipherText = sm2Engine.processBlock(plainText, 0, plainText.length);
        return HexUtil.encodeHexStr((byte[])cipherText);
    }

    public static String encrypt(String data, PublicKey publicKey) throws Exception {
        ECPublicKeyParameters ecPublicKeyParameters = null;
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey bcecPublicKey = (BCECPublicKey)publicKey;
            ECParameterSpec ecParameterSpec = bcecPublicKey.getParameters();
            ECDomainParameters ecDomainParameters = new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
            ecPublicKeyParameters = new ECPublicKeyParameters(bcecPublicKey.getQ(), ecDomainParameters);
        }
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom(ecPublicKeyParameters, SecureRandom.getInstance(SECURE_RANDOM)));
        byte[] plainText = data.getBytes();
        byte[] cipherText = sm2Engine.processBlock(plainText, 0, plainText.length);
        return HexUtil.encodeHexStr((byte[])cipherText);
    }

    public static String decrypt(String encryptedStr, String privateKey) throws Exception {
        BigInteger privateKeyD = new BigInteger(privateKey, 16);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, ecDomainParameters);
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(false, (CipherParameters)privateKeyParameters);
        byte[] encryptedData = SecureUtil.decode((String)encryptedStr);
        byte[] arrayOfBytes = sm2Engine.processBlock(encryptedData, 0, encryptedData.length);
        return new String(arrayOfBytes, "UTF-8");
    }

    public static String decrypt(String encryptedStr, PrivateKey privateKey) throws Exception {
        BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)privateKey;
        ECParameterSpec ecParameterSpec = bcecPrivateKey.getParameters();
        ECDomainParameters ecDomainParameters = new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(bcecPrivateKey.getD(), ecDomainParameters);
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        byte[] encryptedData = SecureUtil.decode((String)encryptedStr);
        byte[] arrayOfBytes = sm2Engine.processBlock(encryptedData, 0, encryptedData.length);
        return new String(arrayOfBytes, "UTF-8");
    }

    public static PublicKey getPublicKey(String pubKeyHex) throws Exception {
        if ((pubKeyHex = SM2Util.unCompressPubKey(pubKeyHex)).length() > 128) {
            pubKeyHex = pubKeyHex.substring(pubKeyHex.length() - 128);
        }
        String stringX = pubKeyHex.substring(0, 64);
        String stringY = pubKeyHex.substring(stringX.length());
        BigInteger x = new BigInteger(stringX, 16);
        BigInteger y = new BigInteger(stringY, 16);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), ecParameterSpec);
        return new BCECPublicKey("EC", ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static PrivateKey getPrivateKey(String privateKeyHex) throws Exception {
        BigInteger d = new BigInteger(privateKeyHex, 16);
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        return new BCECPrivateKey("EC", ecPrivateKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    private static AsymmetricCipherKeyPair genKeyPair0() {
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        try {
            keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(ecDomainParameters, SecureRandom.getInstance(SECURE_RANDOM)));
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u751f\u6210\u516c\u79c1\u94a5\u5bf9\u65f6\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGenerator.generateKeyPair();
        return asymmetricCipherKeyPair;
    }

    public static Pair<String, String> genKeyPair() {
        return SM2Util.genKeyPair(true);
    }

    public static Pair<String, String> genKeyPair(boolean compressedPubKey) {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = SM2Util.genKeyPair0();
        ECPoint ecPoint = ((ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getQ();
        String pubKey = Hex.toHexString((byte[])ecPoint.getEncoded(compressedPubKey));
        BigInteger privatekey = ((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getD();
        String priKey = privatekey.toString(16);
        return Pair.of((Object)pubKey, (Object)priKey);
    }

    public static String compressPubKey(String pubKey) {
        if (pubKey.startsWith("02") || pubKey.startsWith("03")) {
            return pubKey;
        }
        if (!pubKey.startsWith("04")) {
            pubKey = StringUtil.build("04", pubKey);
        }
        ECPoint pukPoint = x9ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
        String compressPubKey = Hex.toHexString((byte[])pukPoint.getEncoded(Boolean.TRUE.booleanValue()));
        return compressPubKey;
    }

    public static String unCompressPubKey(String compressKey) {
        if (compressKey.startsWith("02") || compressKey.startsWith("03")) {
            ECPoint pukPoint = x9ECParameters.getCurve().decodePoint(Hex.decode((String)compressKey));
            String pubKey = Hex.toHexString((byte[])pukPoint.getEncoded(Boolean.FALSE.booleanValue()));
            pubKey = pubKey.substring(2);
            return pubKey;
        }
        if (compressKey.startsWith("04")) {
            compressKey = compressKey.substring(2);
        }
        return compressKey;
    }
}

