/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.util.JSONStringer;

public class ResultMessage
implements Serializable {
    private static final long serialVersionUID = 7020909144998977324L;
    public static final int SUCCESS = 1;
    public static final int FAIL = 0;
    public static final int WARN = 2;
    public static final int ERROR = -1;
    public static final int TIMEOUT = -2;
    private int result = 1;
    private String message = "";
    private String cause = "";
    private Map<String, Object> vars = new HashMap<String, Object>();

    public ResultMessage() {
    }

    public ResultMessage(int result) {
        this.result = result;
    }

    public ResultMessage(int result, String message) {
        this.result = result;
        this.message = message;
    }

    public ResultMessage(int result, String message, String cause) {
        this.result = result;
        this.message = message;
        this.cause = cause;
    }

    public boolean isSuccess() {
        return 1 == this.result;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public static ResultMessage getSuccess(String message) {
        return new ResultMessage(1, message);
    }

    public static ResultMessage getSuccess() {
        return new ResultMessage(1, "");
    }

    public static ResultMessage getFail(String message) {
        return new ResultMessage(0, message);
    }

    public void addVariable(String key, Object value) {
        this.vars.put(key, value);
    }

    public Map<String, Object> getVars() {
        return this.vars;
    }

    public void setVars(Map<String, Object> vars) {
        this.vars = vars;
    }

    public String toString() {
        JSONStringer stringer = new JSONStringer();
        stringer.object().key("result").value((long)this.result).key("message").value((Object)this.message).key("cause").value((Object)this.cause);
        if (!this.vars.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.vars.entrySet()) {
                stringer.key(entry.getKey()).value(entry.getValue());
            }
        }
        stringer.endObject();
        return stringer.toString();
    }
}

