/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.helper;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.LiteTimeoutBlockingWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.util.concurrent.TimeUnit;

public class DisruptorHelper {
    public static WaitStrategy createWaitStrategy(String scheduledWaitStrategy, long scheduledWaitStrategyTimeout, TimeUnit scheduledWaitStrategyTimeUnit) {
        BlockingWaitStrategy waitStrategy = new BlockingWaitStrategy();
        if ("blocking".equalsIgnoreCase(scheduledWaitStrategy)) {
            waitStrategy = new BlockingWaitStrategy();
        } else if ("liteBlocking".equalsIgnoreCase(scheduledWaitStrategy)) {
            waitStrategy = new LiteBlockingWaitStrategy();
        } else if ("busySpin".equalsIgnoreCase(scheduledWaitStrategy)) {
            waitStrategy = new BusySpinWaitStrategy();
        } else if ("timeoutBlocking".equalsIgnoreCase(scheduledWaitStrategy)) {
            waitStrategy = new TimeoutBlockingWaitStrategy(scheduledWaitStrategyTimeout, scheduledWaitStrategyTimeUnit);
        } else if ("liteTimeoutBlocking".equalsIgnoreCase(scheduledWaitStrategy)) {
            waitStrategy = new LiteTimeoutBlockingWaitStrategy(scheduledWaitStrategyTimeout, scheduledWaitStrategyTimeUnit);
        } else if ("yeilding".equalsIgnoreCase(scheduledWaitStrategy)) {
            waitStrategy = new YieldingWaitStrategy();
        } else if ("sleeping".equalsIgnoreCase(scheduledWaitStrategy)) {
            waitStrategy = new SleepingWaitStrategy();
        }
        return waitStrategy;
    }
}

