/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbpsClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(IbpsClassLoader.class);
    private String baseClassDir = "";

    public IbpsClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    public IbpsClassLoader(String baseClassDir) {
        this();
        this.baseClassDir = baseClassDir;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug("Start loading class {} ...", (Object)name);
        }
        byte[] data = this.loadClassData(name);
        return this.defineClass(name, data, 0, data.length);
    }

    private byte[] loadClassData(String name) throws ClassNotFoundException {
        File file = this.getFile(name);
        FileInputStream fis = null;
        byte[] arrData = null;
        try {
            fis = new FileInputStream(file);
            arrData = new byte[(int)file.length()];
            fis.read(arrData);
            byte[] byArray = arrData;
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private File getFile(String name) throws ClassNotFoundException {
        File dir = new File(this.baseClassDir);
        if (!dir.exists()) {
            throw new ClassNotFoundException(this.baseClassDir + " \u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        String classPath = this.baseClassDir.replaceAll("[\\\\]", "/");
        int offset = classPath.lastIndexOf(47);
        name = name.replaceAll("[.]", "/");
        if (offset != -1 && offset < classPath.length() - 1) {
            classPath = classPath + "/";
        }
        if (!(dir = new File(classPath = classPath + name + ".class")).exists()) {
            throw new ClassNotFoundException(dir + " \u4e0d\u5b58\u5728\uff01");
        }
        return dir;
    }

    public String getBaseClassDir() {
        return this.baseClassDir;
    }

    public void setBaseClassDir(String baseClassDir) {
        this.baseClassDir = baseClassDir;
    }
}

