/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.monitor;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.lc.ibps.base.core.config.CommonConfig;
import com.lc.ibps.base.core.util.EnvUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.util.StopWatch;

public class StopWatchUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopWatchUtil.class);
    private static final String KEY_LEVEL = "level";
    private static final String KEY_WATCH = "watch";
    private static final Map<String, Object> currentLocalWatchMap = new ConcurrentHashMap<String, Object>(16);
    private static final ThreadLocal<String> localCurrentId = new ThreadLocal();
    private static final ThreadLocal<Level> localCurrentLevel = new ThreadLocal();
    private static final ThreadLocal<Map<String, Map<String, StopWatch>>> localCurrentWatchs = new ThreadLocal();
    private static final ThreadLocal<String> localId = new TransmittableThreadLocal();
    private static final ThreadLocal<Level> localLevel = new TransmittableThreadLocal();
    private static final ThreadLocal<Map<String, Map<String, StopWatch>>> localWatchs = new TransmittableThreadLocal();

    private static boolean isOpen() {
        return EnvUtil.getBean(CommonConfig.class).isStopwatchEnabled();
    }

    private static Map<String, Map<String, StopWatch>> get() {
        ConcurrentHashMap<String, Map<String, StopWatch>> watchs = null;
        if (localWatchs.get() == null) {
            watchs = new ConcurrentHashMap();
            localWatchs.set(watchs);
        } else {
            watchs = localWatchs.get();
        }
        return watchs;
    }

    private static Map<String, StopWatch> getStopWatchMap() {
        String key;
        Map<String, Map<String, StopWatch>> watchs = StopWatchUtil.get();
        Map<String, StopWatch> steps = watchs.get(key = StopWatchUtil.getId());
        if (steps == null) {
            steps = new LinkedHashMap<String, StopWatch>();
            watchs.put(key, steps);
        }
        return steps;
    }

    private static StopWatch get(String step) {
        Map<String, StopWatch> steps = StopWatchUtil.getStopWatchMap();
        StopWatch watch = steps.get(step);
        if (watch == null) {
            watch = new StopWatch(step);
            steps.put(step, watch);
        }
        return watch;
    }

    private static void remove() {
        StopWatchUtil.get().remove(StopWatchUtil.getId());
    }

    private static void remove(String step) {
        Map<String, StopWatch> steps = StopWatchUtil.getStopWatchMap();
        steps.remove(step);
    }

    public static void stopAndStartNew(String step, String taskName) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stop(step);
            StopWatchUtil.start(step, taskName);
        }
    }

    public static void start(String step, String taskName) {
        if (StopWatchUtil.isOpen()) {
            StopWatch watch = StopWatchUtil.get(step);
            if (watch.isRunning()) {
                StopWatchUtil.log(StopWatchUtil.getLevel().toInt(), "###### watch id: {}, step: {} is running!", StopWatchUtil.getId(), step);
                return;
            }
            watch.start(StringUtil.build(StopWatchUtil.getId(), ":", step, ":", taskName));
        }
    }

    public static void stopAndPrint(String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stop(step);
            StopWatchUtil.print(step);
        }
    }

    public static void stopAndPrintAndClean(String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stop(step);
            StopWatchUtil.print(step);
            StopWatchUtil.clean();
        }
    }

    public static void stopAndPrint(String step, boolean remove) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stop(step);
            StopWatchUtil.print(step, remove);
        }
    }

    public static void stop(String step) {
        StopWatch watch;
        if (StopWatchUtil.isOpen() && (watch = StopWatchUtil.get(step)).isRunning()) {
            watch.stop();
        }
    }

    public static void print() {
        if (StopWatchUtil.isOpen()) {
            Map<String, StopWatch> watchs = StopWatchUtil.getStopWatchMap();
            for (Map.Entry<String, StopWatch> e : watchs.entrySet()) {
                StopWatchUtil.print(e.getKey(), false);
            }
            StopWatchUtil.remove();
        }
    }

    public static void print(String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.print(step, true);
        }
    }

    public static void print(String step, boolean remove) {
        if (StopWatchUtil.isOpen()) {
            String[] prettyArray;
            StopWatch watch = StopWatchUtil.get(step);
            if (watch.isRunning()) {
                watch.stop();
            }
            String pretty = watch.prettyPrint();
            for (String pretty0 : prettyArray = pretty.split("\\n")) {
                StopWatchUtil.log(step, pretty0);
            }
            if (remove) {
                StopWatchUtil.remove(step);
            }
        }
    }

    public static String getPretty(String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatch watch = StopWatchUtil.get(step);
            if (watch.isRunning()) {
                watch.stop();
            }
            return watch.prettyPrint();
        }
        return "";
    }

    private static void log(String step, String pretty) {
        StopWatchUtil.log(StopWatchUtil.getLevel().toInt(), "###### watch id: {}, step: {}, pretty: {}", StopWatchUtil.getId(), step, pretty);
    }

    public static void init(String id, Level level) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.setId(id);
            StopWatchUtil.setLevel(level);
        }
    }

    public static void initAndStart(String id, Level level, String step, String taskName) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.init(id, level);
            StopWatchUtil.start(step, taskName);
        }
    }

    public static void setId(String id) {
        localId.set(id);
    }

    public static String getId() {
        return localId.get();
    }

    public static void setLevel(Level level) {
        localLevel.set(level);
    }

    public static Level getLevel() {
        if (localLevel.get() == null) {
            return Level.TRACE;
        }
        return localLevel.get();
    }

    public static void cleanId() {
        localId.remove();
    }

    public static void cleanLevel() {
        localLevel.remove();
    }

    public static void cleanWatch() {
        localWatchs.remove();
    }

    public static void clean() {
        StopWatchUtil.cleanId();
        StopWatchUtil.cleanLevel();
        StopWatchUtil.cleanWatch();
    }

    private static Map<String, Map<String, StopWatch>> getCurrent() {
        ConcurrentHashMap<String, Map<String, StopWatch>> watchs = null;
        if (localCurrentWatchs.get() == null) {
            watchs = new ConcurrentHashMap();
            localCurrentWatchs.set(watchs);
        } else {
            watchs = localCurrentWatchs.get();
        }
        return watchs;
    }

    private static Map<String, StopWatch> getCurrentStopWatchMap() {
        String key;
        Map<String, Map<String, StopWatch>> watchs = StopWatchUtil.getCurrent();
        Map<String, StopWatch> steps = watchs.get(key = StopWatchUtil.getCurrentId());
        if (steps == null) {
            steps = new LinkedHashMap<String, StopWatch>();
            watchs.put(key, steps);
        }
        return steps;
    }

    private static StopWatch getCurrent(String step) {
        Map<String, StopWatch> steps = StopWatchUtil.getCurrentStopWatchMap();
        StopWatch watch = steps.get(step);
        if (watch == null) {
            watch = new StopWatch(step);
            steps.put(step, watch);
        }
        return watch;
    }

    private static void removeCurrent() {
        StopWatchUtil.getCurrent().remove(StopWatchUtil.getCurrentId());
    }

    private static void removeCurrent(String step) {
        Map<String, StopWatch> steps = StopWatchUtil.getCurrentStopWatchMap();
        steps.remove(step);
    }

    public static void stopAndStartNewCurrent(String step, String taskName) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stopCurrent(step);
            StopWatchUtil.startCurrent(step, taskName);
        }
    }

    public static void startCurrent(String step, String taskName) {
        if (StopWatchUtil.isOpen()) {
            StopWatch watch = StopWatchUtil.getCurrent(step);
            if (watch.isRunning()) {
                StopWatchUtil.log(StopWatchUtil.getCurrentLevel().toInt(), "###### watch id: {}, step: {} is running!", StopWatchUtil.getCurrentId(), step);
                return;
            }
            watch.start(StringUtil.build(StopWatchUtil.getCurrentId(), ":", step, ":", taskName));
        }
    }

    public static void stopAndPrintCurrent(String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stopCurrent(step);
            StopWatchUtil.printCurrent(step);
        }
    }

    public static void stopAndPrintAndCleanCurrent(String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stopCurrent(step);
            StopWatchUtil.printCurrent(step);
            StopWatchUtil.cleanCurrent();
        }
    }

    public static void stopAndPrintCurrent(String step, boolean remove) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stopCurrent(step);
            StopWatchUtil.printCurrent(step, remove);
        }
    }

    public static void stopCurrent(String step) {
        StopWatch watch;
        if (StopWatchUtil.isOpen() && (watch = StopWatchUtil.getCurrent(step)).isRunning()) {
            watch.stop();
        }
    }

    public static void printCurrent() {
        if (StopWatchUtil.isOpen()) {
            Map<String, StopWatch> watchs = StopWatchUtil.getCurrentStopWatchMap();
            for (Map.Entry<String, StopWatch> e : watchs.entrySet()) {
                StopWatchUtil.printCurrent(e.getKey(), false);
            }
            StopWatchUtil.removeCurrent();
        }
    }

    public static void printCurrent(String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.printCurrent(step, true);
        }
    }

    public static void printCurrent(String step, boolean remove) {
        if (StopWatchUtil.isOpen()) {
            String[] prettyArray;
            StopWatch watch = StopWatchUtil.getCurrent(step);
            if (watch.isRunning()) {
                watch.stop();
            }
            String pretty = watch.prettyPrint();
            for (String pretty0 : prettyArray = pretty.split("\\n")) {
                StopWatchUtil.logCurrent(step, pretty0);
            }
            if (remove) {
                StopWatchUtil.removeCurrent(step);
            }
        }
    }

    public static String getPrettyCurrent(String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatch watch = StopWatchUtil.getCurrent(step);
            if (watch.isRunning()) {
                watch.stop();
            }
            return watch.prettyPrint();
        }
        return "";
    }

    private static void logCurrent(String step, String pretty) {
        StopWatchUtil.log(StopWatchUtil.getCurrentLevel().toInt(), "###### watch id: {}, step: {}, pretty: {}", StopWatchUtil.getCurrentId(), step, pretty);
    }

    public static void initCurrent(String id, Level level) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.setCurrentId(id);
            StopWatchUtil.setCurrentLevel(level);
        }
    }

    public static void initAndStartCurrent(String id, Level level, String step, String taskName) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.initCurrent(id, level);
            StopWatchUtil.startCurrent(step, taskName);
        }
    }

    public static void setCurrentId(String id) {
        localCurrentId.set(id);
    }

    public static String getCurrentId() {
        return localCurrentId.get();
    }

    public static void setCurrentLevel(Level level) {
        localCurrentLevel.set(level);
    }

    public static Level getCurrentLevel() {
        if (localCurrentLevel.get() == null) {
            return Level.TRACE;
        }
        return localCurrentLevel.get();
    }

    public static void cleanCurrentId() {
        localCurrentId.remove();
    }

    public static void cleanCurrentLevel() {
        localCurrentLevel.remove();
    }

    public static void cleanCurrentWatch() {
        localCurrentWatchs.remove();
    }

    public static void cleanCurrent() {
        StopWatchUtil.cleanCurrentId();
        StopWatchUtil.cleanCurrentLevel();
        StopWatchUtil.cleanCurrentWatch();
    }

    private static Map<String, StopWatch> getLocalStopWatchMap(String id) {
        String key = StringUtil.build(id, ":", KEY_WATCH);
        LinkedHashMap steps = (LinkedHashMap)currentLocalWatchMap.get(key);
        if (steps == null) {
            steps = new LinkedHashMap();
            currentLocalWatchMap.put(key, steps);
        }
        return steps;
    }

    private static Level getLocalLevel(String id) {
        String key = StringUtil.build(id, ":", KEY_LEVEL);
        Level level = (Level)currentLocalWatchMap.get(key);
        if (level == null) {
            level = Level.TRACE;
            currentLocalWatchMap.put(key, level);
        }
        return level;
    }

    private static StopWatch getLocal(String id, String step) {
        Map<String, StopWatch> steps = StopWatchUtil.getLocalStopWatchMap(id);
        StopWatch watch = steps.get(step);
        if (watch == null) {
            watch = new StopWatch(step);
            steps.put(step, watch);
        }
        return watch;
    }

    private static void removeLocal(String id) {
        StopWatchUtil.getLocalStopWatchMap(id).remove(id);
    }

    private static void removeLocal(String id, String step) {
        Map<String, StopWatch> steps = StopWatchUtil.getLocalStopWatchMap(id);
        steps.remove(step);
    }

    public static void stopAndStartNewLocal(String id, String step, String taskName) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stopLocal(id, step);
            StopWatchUtil.startLocal(id, step, taskName);
        }
    }

    public static void startLocal(String id, String step, String taskName) {
        if (StopWatchUtil.isOpen()) {
            StopWatch watch = StopWatchUtil.getLocal(id, step);
            if (watch.isRunning()) {
                StopWatchUtil.log(StopWatchUtil.getLocalLevel(id).toInt(), "###### watch id: {}, step: {} is running!", id, step);
                return;
            }
            watch.start(StringUtil.build(id, ":", step, ":", taskName));
        }
    }

    public static void stopAndPrintLocal(String id, String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stopLocal(id, step);
            StopWatchUtil.printLocal(id, step);
        }
    }

    public static void stopAndPrintAndCleanLocal(String id, String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stopLocal(id, step);
            StopWatchUtil.printLocal(id, step);
            StopWatchUtil.cleanLocal(id);
        }
    }

    public static void stopAndPrintLocal(String id, String step, boolean remove) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.stopLocal(id, step);
            StopWatchUtil.printLocal(id, step, remove);
        }
    }

    public static void stopLocal(String id, String step) {
        StopWatch watch;
        if (StopWatchUtil.isOpen() && (watch = StopWatchUtil.getLocal(id, step)).isRunning()) {
            watch.stop();
        }
    }

    public static void printLocal(String id) {
        if (StopWatchUtil.isOpen()) {
            Map<String, StopWatch> watchs = StopWatchUtil.getLocalStopWatchMap(id);
            for (Map.Entry<String, StopWatch> e : watchs.entrySet()) {
                StopWatchUtil.printLocal(id, e.getKey(), false);
            }
            StopWatchUtil.removeLocal(id);
        }
    }

    public static void printLocal(String id, String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.printLocal(id, step, true);
        }
    }

    public static void printLocal(String id, String step, boolean remove) {
        if (StopWatchUtil.isOpen()) {
            String[] prettyArray;
            StopWatch watch = StopWatchUtil.getLocal(id, step);
            if (watch.isRunning()) {
                watch.stop();
            }
            String pretty = watch.prettyPrint();
            for (String pretty0 : prettyArray = pretty.split("\\n")) {
                StopWatchUtil.logLocal(id, step, pretty0);
            }
            if (remove) {
                StopWatchUtil.removeLocal(id, step);
            }
        }
    }

    public static String getPrettyLocal(String id, String step) {
        if (StopWatchUtil.isOpen()) {
            StopWatch watch = StopWatchUtil.getLocal(id, step);
            if (watch.isRunning()) {
                watch.stop();
            }
            return watch.prettyPrint();
        }
        return "";
    }

    private static void logLocal(String id, String step, String pretty) {
        StopWatchUtil.log(StopWatchUtil.getLocalLevel(id).toInt(), "###### watch id: {}, step: {}, pretty: {}", id, step, pretty);
    }

    public static void initLocal(String id, Level level) {
        String key = StringUtil.build(id, ":", KEY_LEVEL);
        currentLocalWatchMap.put(key, level);
    }

    public static void initAndStartLocal(String id, Level level, String step, String taskName) {
        if (StopWatchUtil.isOpen()) {
            StopWatchUtil.initLocal(id, level);
            StopWatchUtil.startLocal(id, step, taskName);
        }
    }

    public static void cleanLocalLevel(String id) {
        String key = StringUtil.build(id, ":", KEY_LEVEL);
        currentLocalWatchMap.remove(key);
    }

    public static void cleanLocalWatch(String id) {
        String key = StringUtil.build(id, ":", KEY_WATCH);
        currentLocalWatchMap.remove(key);
    }

    public static void cleanLocal(String id) {
        StopWatchUtil.cleanLocalLevel(id);
        StopWatchUtil.cleanLocalWatch(id);
    }

    private static void log(int level, String message, Object ... args) {
        if (Level.DEBUG.toInt() == level && LOGGER.isDebugEnabled()) {
            LOGGER.debug(message, args);
        } else if (Level.INFO.toInt() == level && LOGGER.isInfoEnabled()) {
            LOGGER.info(message, args);
        } else if (Level.WARN.toInt() == level && LOGGER.isWarnEnabled()) {
            LOGGER.warn(message, args);
        } else if (Level.ERROR.toInt() == level && LOGGER.isErrorEnabled()) {
            LOGGER.error(message, args);
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(message, args);
        }
    }
}

