/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.thread;

import com.lc.ibps.base.core.util.string.StringUtil;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class CustomThreadFactory
implements ThreadFactory {
    private final AtomicLong threadNumber = new AtomicLong(1L);
    private final String threadGroupName;

    public CustomThreadFactory(String threadGroupName) {
        this.threadGroupName = threadGroupName;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        ThreadGroup threadGroup = new ThreadGroup(this.threadGroupName);
        Thread thread = new Thread(threadGroup, runnable, StringUtil.build(threadGroup.getName(), "-", this.threadNumber.getAndIncrement()));
        thread.setDaemon(true);
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

