/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.thread;

import com.google.common.collect.Maps;
import com.lc.ibps.base.core.thread.DateFormatThreadLocal;
import java.text.DateFormat;
import java.util.Map;
import java.util.Objects;

public class DateFormatThreadUtil {
    private static final Map<String, ThreadLocal<DateFormat>> FORMATS = Maps.newConcurrentMap();

    public static DateFormat get(String pattern) {
        ThreadLocal<DateFormat> format = FORMATS.get(pattern);
        if (Objects.isNull(format)) {
            FORMATS.putIfAbsent(pattern, new DateFormatThreadLocal(pattern));
        }
        return FORMATS.get(pattern).get();
    }

    public static void cleanAll() {
        FORMATS.values().stream().forEach(t -> t.remove());
    }

    static {
        FORMATS.put("yyyy-MM-dd HH:mm:ss.SSS", new DateFormatThreadLocal("yyyy-MM-dd HH:mm:ss.SSS"));
        FORMATS.put("yyyy-MM-dd HH:mm:ss", new DateFormatThreadLocal("yyyy-MM-dd HH:mm:ss"));
        FORMATS.put("yyyy-MM-dd HH:mm", new DateFormatThreadLocal("yyyy-MM-dd HH:mm"));
        FORMATS.put("yyyy-MM-dd HH", new DateFormatThreadLocal("yyyy-MM-dd HH"));
        FORMATS.put("yyyy-MM-dd", new DateFormatThreadLocal("yyyy-MM-dd"));
        FORMATS.put("yyyyMMdd", new DateFormatThreadLocal("yyyyMMdd"));
        FORMATS.put("yyyy-MM", new DateFormatThreadLocal("yyyy-MM"));
        FORMATS.put("yyyyMM", new DateFormatThreadLocal("yyyyMM"));
        FORMATS.put("yyyy", new DateFormatThreadLocal("yyyy"));
        FORMATS.put("HH:mm:ss", new DateFormatThreadLocal("HH:mm:ss"));
        FORMATS.put("HH:mm", new DateFormatThreadLocal("HH:mm"));
    }
}

