/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.google.common.collect.Maps;
import com.lc.ibps.base.core.util.time.DurationUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;

public class BeanCostUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanCostUtil.class);
    private static final Map<String, LocalDateTime> LOCAL_DATE_TIME_MAP = Maps.newConcurrentMap();
    private static final AtomicLong ALL_COST = new AtomicLong();

    public static void put(String beanName) {
        LOCAL_DATE_TIME_MAP.putIfAbsent(beanName, LocalDateTime.now());
    }

    public static void print(String beanName) {
        LocalDateTime start = LOCAL_DATE_TIME_MAP.remove(beanName);
        if (Objects.nonNull(start)) {
            Pair<String, Long> pair = DurationUtil.createPair(start);
            ALL_COST.addAndGet((Long)pair.getSecond());
            String str = (String)pair.getFirst();
            if ((Long)pair.getSecond() > 300L) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Created of {} cost={}.", (Object)beanName, (Object)str);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Created of {} cost={}.", (Object)beanName, (Object)str);
            }
        }
    }

    public static void printTotal() {
        String str = DurationUtil.createStr(Duration.ofMillis(ALL_COST.get()));
        if (logger.isInfoEnabled()) {
            logger.info("Created beans cost={}.", (Object)str);
        }
    }
}

