/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.lc.ibps.base.core.exception.BaseException;
import com.lc.ibps.base.core.exception.NotRequiredI18nException;
import com.lc.ibps.base.core.exception.spi.SpiExceptionService;
import com.lc.ibps.base.core.util.I18nUtil;
import com.lc.ibps.base.core.util.SpiServiceUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;

public class ExceptionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionUtil.class);

    private ExceptionUtil() {
    }

    public static RuntimeException unchecked(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static String getStackTraceAsString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static boolean isCausedBy(Exception ex, Class<? extends Exception> ... causeExceptionClasses) {
        for (Class<? extends Exception> causeClass : causeExceptionClasses) {
            if (!causeClass.isInstance(ex)) continue;
            return true;
        }
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeExceptionClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return true;
            }
        }
        return false;
    }

    public static Pair<Integer, String> analysisCauseWithState(Exception exception) {
        Object[] args;
        int state;
        Pair pairDefault = null;
        if (exception instanceof BaseException) {
            state = ((BaseException)exception).getState();
            args = ((BaseException)exception).getArgs();
            pairDefault = Pair.of((Object)state, (Object)I18nUtil.getMessage(StringUtil.build("state.", state), args));
        }
        if (exception instanceof NotRequiredI18nException) {
            state = ((NotRequiredI18nException)exception).getState();
            pairDefault = Pair.of((Object)state, (Object)I18nUtil.getMessage(StringUtil.build("state.", state)));
        }
        if (exception.getCause() == null) {
            if (exception instanceof BaseException) {
                state = ((BaseException)exception).getState();
                args = ((BaseException)exception).getArgs();
                Pair rtn = Pair.of((Object)state, (Object)I18nUtil.getMessage(StringUtil.build("state.", state), args));
                if ((Integer)rtn.getFirst() != -500) {
                    return rtn;
                }
                return pairDefault;
            }
            if (Objects.nonNull(pairDefault) && (Integer)pairDefault.getFirst() != -500) {
                return pairDefault;
            }
            return Pair.of((Object)-500, (Object)(I18nUtil.getMessage("state.-500") + ":" + exception.getMessage()));
        }
        Pair<Integer, String> rtn = ExceptionUtil.analysisCauseWithState(exception.getCause());
        if (pairDefault == null || (Integer)rtn.getFirst() != -500) {
            return rtn;
        }
        return pairDefault;
    }

    public static Pair<Integer, String> analysisCauseWithState(Throwable throwable) {
        if (null == throwable) {
            return Pair.of((Object)500, (Object)I18nUtil.getMessage("state.500"));
        }
        ArrayList<Throwable> throwableStacks = new ArrayList<Throwable>();
        ExceptionUtil.createThrowableStacks(throwable, throwableStacks);
        Collections.reverse(throwableStacks);
        SpiExceptionService spiExceptionService2 = null;
        String exceptionClassName = null;
        for (Throwable throwable0 : throwableStacks) {
            exceptionClassName = throwable0.getClass().getName();
            ServiceLoader<SpiExceptionService> loader = SpiServiceUtil.loadAll(SpiExceptionService.class);
            for (SpiExceptionService spiExceptionService2 : loader) {
                Pair<Integer, String> pair;
                String classname = null;
                try {
                    classname = spiExceptionService2.getClassName();
                }
                catch (NoClassDefFoundError e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("{}", (Object)e.getMessage());
                    continue;
                }
                if (!exceptionClassName.equals(classname) || -500 == (Integer)(pair = spiExceptionService2.analysisWithState(throwable0)).getFirst()) continue;
                return pair;
            }
        }
        return Pair.of((Object)-500, (Object)(I18nUtil.getMessage("state.-500") + ":" + throwable.getMessage()));
    }

    public static String analysisCause(Exception exception) {
        if (exception.getCause() == null) {
            return ExceptionUtil.analysisException(exception);
        }
        return ExceptionUtil.analysisCause(exception.getCause());
    }

    private static String analysisException(Exception exception) {
        if (null == exception) {
            return "";
        }
        SpiExceptionService spiExceptionService2 = null;
        String exceptionClassName = null;
        exceptionClassName = exception.getClass().getName();
        String message = null;
        ServiceLoader<SpiExceptionService> loader = SpiServiceUtil.loadAll(SpiExceptionService.class);
        for (SpiExceptionService spiExceptionService2 : loader) {
            String classname = null;
            try {
                classname = spiExceptionService2.getClassName();
            }
            catch (NoClassDefFoundError e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("{}", (Object)e.getMessage());
                continue;
            }
            if (!exceptionClassName.equals(classname) || !StringUtil.isNotBlank((CharSequence)(message = spiExceptionService2.analysis(exception)))) continue;
            return message;
        }
        return exception.getMessage();
    }

    public static String analysisCause(Throwable throwable) {
        if (null == throwable) {
            return "";
        }
        ArrayList<Throwable> throwableStacks = new ArrayList<Throwable>();
        ExceptionUtil.createThrowableStacks(throwable, throwableStacks);
        Collections.reverse(throwableStacks);
        SpiExceptionService spiExceptionService2 = null;
        String exceptionClassName = null;
        String message = null;
        for (Throwable throwable0 : throwableStacks) {
            exceptionClassName = throwable0.getClass().getName();
            ServiceLoader<SpiExceptionService> loader = SpiServiceUtil.loadAll(SpiExceptionService.class);
            for (SpiExceptionService spiExceptionService2 : loader) {
                String classname = null;
                try {
                    classname = spiExceptionService2.getClassName();
                }
                catch (NoClassDefFoundError e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("{}", (Object)e.getMessage());
                    continue;
                }
                if (!exceptionClassName.equals(classname) || !StringUtil.isNotBlank((CharSequence)(message = spiExceptionService2.analysis(throwable0)))) continue;
                return message;
            }
        }
        return throwable.getMessage();
    }

    private static void createThrowableStacks(Throwable throwable, List<Throwable> throwableStacks) {
        if (null == throwable) {
            return;
        }
        throwableStacks.add(throwable);
        Throwable t = throwable.getCause();
        if (t == null) {
            return;
        }
        ExceptionUtil.createThrowableStacks(throwable.getCause(), throwableStacks);
    }
}

