/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.lc.ibps.base.core.exception.BaseException;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.ThreadContextUtil;
import com.lc.ibps.base.core.util.jackson.DateJsonDeserializer;
import com.lc.ibps.base.core.util.jackson.DateJsonSerializer;
import com.lc.ibps.base.core.util.jackson.NullJsonSerializer;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class JacksonUtil {
    private static Logger logger = LoggerFactory.getLogger(JacksonUtil.class);
    private static ObjectMapper mapper;
    private static Module defaultModule;
    private static boolean threadable;
    private static boolean dateable;

    private JacksonUtil() {
    }

    public static void setMapper(ObjectMapper mapper) {
        JacksonUtil.mapper = mapper;
    }

    public static ObjectMapper getMapper() {
        if (BeanUtils.isEmpty(mapper)) {
            mapper = JacksonUtil.mapper(defaultModule);
        }
        return mapper;
    }

    public static void setThreadable(boolean threadable) {
        JacksonUtil.threadable = threadable;
    }

    public static void setDateable(boolean dateable) {
        JacksonUtil.dateable = dateable;
    }

    public static ObjectMapper mapper(Module defaultModule) {
        return JacksonUtil.mapper("yyyy-MM-dd HH:mm:ss", null, defaultModule);
    }

    public static ObjectMapper mapper(String dateFormat, Module defaultModule) {
        return JacksonUtil.mapper(dateFormat, null, defaultModule);
    }

    public static ObjectMapper mapper(String dateFormat, JsonSerializer<Object> nullValueSerializer, Module defaultModule) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (Objects.nonNull(defaultModule)) {
            mapper.registerModule(defaultModule);
        }
        if (dateable) {
            SimpleModule module = new SimpleModule();
            module.addSerializer(Date.class, JacksonUtil.createDateSerializer(dateFormat));
            module.addDeserializer(Date.class, JacksonUtil.createDateDeserializer(dateFormat));
            mapper.registerModule((Module)module);
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            mapper.setDateFormat((DateFormat)simpleDateFormat);
            mapper.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        }
        if (Objects.nonNull(nullValueSerializer)) {
            mapper.getSerializerProvider().setNullValueSerializer(nullValueSerializer);
        }
        return mapper;
    }

    private static JsonSerializer<Date> createDateSerializer(String dateFormat) {
        return new DateJsonSerializer(dateFormat);
    }

    private static JsonDeserializer<Date> createDateDeserializer(String dateFormat) {
        return new DateJsonDeserializer(dateFormat);
    }

    public static JsonSerializer<Object> createNullStringAsBlankSerializer() {
        return new NullJsonSerializer();
    }

    public static boolean isEmpty(Object o) {
        if (o instanceof String) {
            if (StringUtil.isBlank((CharSequence)o.toString()) || JacksonUtil.isNullJson((String)o).booleanValue()) {
                return true;
            }
            return !JacksonUtil.isJson(o.toString());
        }
        return BeanUtils.isEmpty(o);
    }

    public static boolean isNotEmpty(Object o) {
        return !JacksonUtil.isEmpty(o);
    }

    public static boolean isJson(String jsonStr) {
        if (threadable && StringUtil.isNotBlank((CharSequence)jsonStr)) {
            String key = StringUtil.build("isJson.", jsonStr);
            Object threadData = ThreadContextUtil.getProperty(key);
            if (Objects.nonNull(threadData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("From thread of {}.", (Object)key);
                }
                return (Boolean)threadData;
            }
            boolean isJson = JacksonUtil.isJsonInner(jsonStr);
            ThreadContextUtil.addProperty(key, isJson);
            return isJson;
        }
        return JacksonUtil.isJsonInner(jsonStr);
    }

    private static boolean isJsonInner(String jsonStr) {
        JsonNode jsonNode = null;
        try {
            jsonNode = JacksonUtil.getMapper().readTree(jsonStr);
        }
        catch (Exception e) {
            try {
                jsonStr = jsonStr.replaceAll("\\\"", "\"");
                jsonNode = JacksonUtil.getMapper().readTree(jsonStr);
            }
            catch (Exception e1) {
                return false;
            }
        }
        return Objects.nonNull(jsonNode) && (jsonNode.isObject() || jsonNode.isArray());
    }

    public static void assert0(String jsonStr, String message) {
        boolean isJson = JacksonUtil.isJson(jsonStr);
        if (!isJson) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isNotJson(String jsonStr) {
        return !JacksonUtil.isJson(jsonStr);
    }

    public static boolean isJsonObject(String jsonStr) {
        if (StringUtil.isBlank((CharSequence)jsonStr) || !jsonStr.startsWith("{") || !jsonStr.endsWith("}")) {
            return false;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getMapper().readTree(jsonStr);
            return jsonNode.isObject();
        }
        catch (Exception e) {
            try {
                jsonStr = jsonStr.replaceAll("\\\"", "\"");
                JsonNode jsonNode = JacksonUtil.getMapper().readTree(jsonStr);
                return jsonNode.isObject();
            }
            catch (Exception e1) {
                return false;
            }
        }
    }

    public static boolean isNotJsonObject(String jsonStr) {
        return !JacksonUtil.isJsonObject(jsonStr);
    }

    public static boolean isJsonArray(String jsonStr) {
        if (StringUtil.isBlank((CharSequence)jsonStr) || !jsonStr.startsWith("[") || !jsonStr.endsWith("]")) {
            return false;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getMapper().readTree(jsonStr);
            return jsonNode.isArray();
        }
        catch (Exception e) {
            try {
                jsonStr = jsonStr.replaceAll("\\\"", "\"");
                JsonNode jsonNode = JacksonUtil.getMapper().readTree(jsonStr);
                return jsonNode.isArray();
            }
            catch (Exception e1) {
                return false;
            }
        }
    }

    public static boolean isNotJsonArray(String jsonStr) {
        return !JacksonUtil.isJsonArray(jsonStr);
    }

    public static String toJsonString(Object obj) {
        if (BeanUtils.isEmpty(obj)) {
            return null;
        }
        try {
            return JacksonUtil.getMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getString(String data, String key) {
        Map dataMap = JacksonUtil.getDTO(data, Map.class);
        Object d = dataMap.get(key);
        if (d instanceof String) {
            return d.toString();
        }
        return JacksonUtil.toJsonString(dataMap.get(key));
    }

    public static Object get(String data, String key) {
        Map dataMap = JacksonUtil.getDTO(data, Map.class);
        return dataMap.get(key);
    }

    public static Map<String, Object> toMap(String data) {
        return JacksonUtil.getDTO(data, Map.class);
    }

    public static <D> Map<String, Object> toMap(D data) {
        if (BeanUtils.isEmpty(data)) {
            return null;
        }
        if (data instanceof String) {
            return JacksonUtil.getDTO(data.toString(), Map.class);
        }
        if (data instanceof Map) {
            return (Map)data;
        }
        return JacksonUtil.getDTO(JacksonUtil.toJsonString(data), Map.class);
    }

    public static <D> List<Map> toMapList(D data) {
        return JacksonUtil.getDTOList(JacksonUtil.toJsonString(data), Map.class);
    }

    public static Map<String, Object> toMapRecursion(String data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtil.isBlank((CharSequence)data)) {
            return result;
        }
        Map<String, Object> dataMap = JacksonUtil.toMap(data);
        JacksonUtil.toMapRecursion0(result, dataMap);
        return result;
    }

    public static void toMapRecursion0(Map<String, Object> result, Map<String, Object> dataMap) {
        Set<Map.Entry<String, Object>> entries = dataMap.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (BeanUtils.isNotEmpty(entry.getValue()) && entry.getValue() instanceof String && JacksonUtil.isJsonObject(entry.getValue().toString())) {
                Map<String, Object> dataMap0 = JacksonUtil.toMapRecursion(entry.getValue().toString());
                result.put(entry.getKey(), dataMap0);
                continue;
            }
            if (BeanUtils.isNotEmpty(entry.getValue()) && entry.getValue() instanceof String && JacksonUtil.isJsonArray(entry.getValue().toString())) {
                List<Map> dataMaps0 = JacksonUtil.toMapsRecursion(entry.getValue().toString());
                result.put(entry.getKey(), dataMaps0);
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
    }

    private static List<Map> toMapsRecursion(String data) {
        ArrayList<Map> result = new ArrayList<Map>();
        if (StringUtil.isBlank((CharSequence)data)) {
            return result;
        }
        List<Map> dataMaps = JacksonUtil.getDTOList(data);
        for (Map dataMap : dataMaps) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            JacksonUtil.toMapRecursion0(resultMap, dataMap);
            result.add(resultMap);
        }
        return result;
    }

    public static <T> T getDTO(String jsonStr, Class<T> clazz) {
        if (StringUtil.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        if (threadable) {
            String key = StringUtil.build(clazz.getName(), ".", jsonStr);
            Object threadData = ThreadContextUtil.getProperty(key);
            if (Objects.nonNull(threadData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("From thread of {}.", (Object)key);
                }
                return (T)threadData;
            }
            try {
                Object data = JacksonUtil.getMapper().readValue(jsonStr, clazz);
                ThreadContextUtil.addProperty(key, data);
                return (T)data;
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try {
            Object data = JacksonUtil.getMapper().readValue(jsonStr, clazz);
            return (T)data;
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getDTO(String jsonStr, Class<T> clazz, String dateFormat) {
        if (StringUtil.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        if (threadable) {
            String key = StringUtil.build(clazz.getName(), ".", dateFormat, ".", jsonStr);
            Object threadData = ThreadContextUtil.getProperty(key);
            if (Objects.nonNull(threadData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("From thread of {}.", (Object)key);
                }
                return (T)threadData;
            }
            try {
                ObjectMapper mapper = JacksonUtil.mapper(dateFormat, defaultModule);
                Object data = mapper.readValue(jsonStr, clazz);
                ThreadContextUtil.addProperty(key, data);
                return (T)data;
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try {
            ObjectMapper mapper = JacksonUtil.mapper(dateFormat, defaultModule);
            Object data = mapper.readValue(jsonStr, clazz);
            return (T)data;
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getDTO(Map map, Class<T> clazz) {
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (threadable) {
            String key = StringUtil.build(clazz.getName(), ".", map.toString());
            Object threadData = ThreadContextUtil.getProperty(key);
            if (Objects.nonNull(threadData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("From thread of {}.", (Object)key);
                }
                return (T)threadData;
            }
            try {
                Object data = JacksonUtil.getMapper().convertValue((Object)map, clazz);
                ThreadContextUtil.addProperty(key, data);
                return (T)data;
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try {
            Object data = JacksonUtil.getMapper().convertValue((Object)map, clazz);
            return (T)data;
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getDTOByObject(Object data, Class<T> clazz) {
        if (BeanUtils.isEmpty(data)) {
            return null;
        }
        if (threadable) {
            String key = StringUtil.build(clazz.getName(), ".", data.toString());
            Object threadData = ThreadContextUtil.getProperty(key);
            if (Objects.nonNull(threadData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("From thread of {}.", (Object)key);
                }
                return (T)threadData;
            }
            try {
                Object dataa = JacksonUtil.getMapper().convertValue(data, clazz);
                ThreadContextUtil.addProperty(key, dataa);
                return (T)dataa;
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try {
            Object dataa = JacksonUtil.getMapper().convertValue(data, clazz);
            return (T)dataa;
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getDTO(Map map, TypeReference<T> ref) {
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (threadable) {
            String key = StringUtil.build(ref.getType().getClass().getName(), ".", map.toString());
            Object threadData = ThreadContextUtil.getProperty(key);
            if (Objects.nonNull(threadData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("From thread of {}.", (Object)key);
                }
                return (T)threadData;
            }
            try {
                Object data = JacksonUtil.getMapper().convertValue((Object)map, ref);
                ThreadContextUtil.addProperty(key, data);
                return (T)data;
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try {
            Object data = JacksonUtil.getMapper().convertValue((Object)map, ref);
            return (T)data;
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Map> getDTOList(String jsonStr) {
        return JacksonUtil.getDTOList(jsonStr, Map.class);
    }

    public static <T> List<T> getDTOList(String jsonStr, Class<T> clazz) {
        if (StringUtil.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        if (threadable) {
            String key = StringUtil.build(clazz.getName(), ".", jsonStr);
            Object threadData = ThreadContextUtil.getProperty(key);
            if (Objects.nonNull(threadData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("From thread of {}.", (Object)key);
                }
                return (List)threadData;
            }
            try {
                CollectionType type = JacksonUtil.getMapper().getTypeFactory().constructCollectionType(List.class, clazz);
                List data = (List)JacksonUtil.getMapper().readValue(jsonStr, (JavaType)type);
                ThreadContextUtil.addProperty(key, data);
                return data;
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try {
            CollectionType type = JacksonUtil.getMapper().getTypeFactory().constructCollectionType(List.class, clazz);
            List data = (List)JacksonUtil.getMapper().readValue(jsonStr, (JavaType)type);
            return data;
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> getDTOListByObject(List<?> datas, Class<T> clazz) {
        if (BeanUtils.isEmpty(datas)) {
            return null;
        }
        try {
            CollectionType type = JacksonUtil.getMapper().getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)JacksonUtil.getMapper().convertValue(datas, (JavaType)type);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> getDTOList(String jsonStr, Class<T> clazz, String dateFormat) {
        if (StringUtil.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        if (threadable) {
            String key = StringUtil.build(clazz.getName(), ".", dateFormat, ".", jsonStr);
            Object threadData = ThreadContextUtil.getProperty(key);
            if (Objects.nonNull(threadData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("From thread of {}.", (Object)key);
                }
                return (List)threadData;
            }
            try {
                ObjectMapper mapper = JacksonUtil.mapper(dateFormat, defaultModule);
                CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
                List data = (List)mapper.readValue(jsonStr, (JavaType)type);
                ThreadContextUtil.addProperty(key, data);
                return data;
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try {
            ObjectMapper mapper = JacksonUtil.mapper(dateFormat, defaultModule);
            CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
            List data = (List)mapper.readValue(jsonStr, (JavaType)type);
            return data;
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> getDTOList(List<Map> datas, Class<T> clazz, String dateFormat) {
        if (BeanUtils.isEmpty(datas)) {
            return null;
        }
        try {
            ObjectMapper mapper = JacksonUtil.mapper(dateFormat, defaultModule);
            CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)mapper.convertValue(datas, (JavaType)type);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Boolean isNullJson(String str) {
        if ("{}".equals(str) || "[]".equals(str)) {
            return true;
        }
        return false;
    }

    public static void validateJsonByFilePath(String schemaJsonFilePath, String valueJson) {
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources(schemaJsonFilePath);
            Resource res = resources[0];
            String schemaJson = IoUtil.read((InputStream)res.getInputStream(), (Charset)CharsetUtil.CHARSET_UTF_8);
            JacksonUtil.validateJson(schemaJson, valueJson);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public static void validateJson(String schemaJson, String valueJson) {
        try {
            JsonNode schemaNode = mapper.readTree(schemaJson);
            JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
            JsonSchema schema = factory.getJsonSchema(schemaNode);
            JsonNode dataNode = mapper.readTree(valueJson);
            ProcessingReport report = schema.validate(dataNode);
            if (!report.isSuccess()) {
                StringJoiner joiner = new StringJoiner(";");
                report.forEach(msg -> joiner.add(msg.getMessage()));
                throw new BaseException(joiner.toString());
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }
}

