/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JvmUtil {
    private static Logger logger = LoggerFactory.getLogger(JvmUtil.class);
    public static String KEY_PLATFORM = "platform";
    public static String KEY_VENDOR = "vendor";
    public static String KEY_VERSION = "version";
    public static String KEY_VM_NAME = "vm.name";
    public static String KEY_VM_VERSION = "vm.version";
    public static String KEY_MAX = "max";
    public static String KEY_TOTAL = "total";
    public static String KEY_USED = "used";
    public static String KEY_AVAILABLE = "available";

    private JvmUtil() {
    }

    public static boolean isDebug() {
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String inputArgument : inputArguments) {
            if (!inputArgument.startsWith("-Xrunjdwp") && !inputArgument.startsWith("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    public static void jvm() {
        JvmUtil.jvmDebug();
    }

    public static void jvmDebug() {
        if (logger.isDebugEnabled()) {
            Map<String, Object> jvmBaseInfo = JvmUtil.jvmBaseInfo();
            logger.debug("=============================================================");
            logger.debug("== {} vendor: {}.", jvmBaseInfo.get(KEY_PLATFORM), jvmBaseInfo.get(KEY_VENDOR));
            logger.debug("== {} version: \"{}\".", jvmBaseInfo.get(KEY_PLATFORM), jvmBaseInfo.get(KEY_VERSION));
            logger.debug("== {} <build {}>.", jvmBaseInfo.get(KEY_VM_NAME), jvmBaseInfo.get(KEY_VM_VERSION));
            logger.debug("== Jvm max memory: {} MB.", jvmBaseInfo.get(KEY_MAX));
            logger.debug("== Jvm total memory: {} MB.", jvmBaseInfo.get(KEY_TOTAL));
            logger.debug("== Jvm used memory: {} MB.", jvmBaseInfo.get(KEY_USED));
            logger.debug("== Jvm available memory: {} MB.", jvmBaseInfo.get(KEY_AVAILABLE));
            logger.debug("=============================================================");
        }
    }

    public static void jvmInfo() {
        if (logger.isInfoEnabled()) {
            Map<String, Object> jvmBaseInfo = JvmUtil.jvmBaseInfo();
            logger.info("=============================================================");
            logger.info("== {} vendor: {}.", jvmBaseInfo.get(KEY_PLATFORM), jvmBaseInfo.get(KEY_VENDOR));
            logger.info("== {} version: \"{}\".", jvmBaseInfo.get(KEY_PLATFORM), jvmBaseInfo.get(KEY_VERSION));
            logger.info("== {} <build {}>.", jvmBaseInfo.get(KEY_VM_NAME), jvmBaseInfo.get(KEY_VM_VERSION));
            logger.info("== Jvm max memory: {} MB.", jvmBaseInfo.get(KEY_MAX));
            logger.info("== Jvm total memory: {} MB.", jvmBaseInfo.get(KEY_TOTAL));
            logger.info("== Jvm used memory: {} MB.", jvmBaseInfo.get(KEY_USED));
            logger.info("== Jvm available memory: {} MB.", jvmBaseInfo.get(KEY_AVAILABLE));
            logger.info("=============================================================");
        }
    }

    public static Map<String, Object> jvmBaseInfo() {
        HashMap jvmBaseInfo = Maps.newHashMap();
        String platform = "Java";
        if (System.getProperty("java.vm.name").startsWith("OpenJDK")) {
            platform = "OpenJDK";
        }
        jvmBaseInfo.put(KEY_PLATFORM, platform);
        jvmBaseInfo.put(KEY_VENDOR, System.getProperty("java.vendor"));
        jvmBaseInfo.put(KEY_VERSION, System.getProperty("java.version"));
        jvmBaseInfo.put(KEY_VM_NAME, System.getProperty("java.vm.name"));
        jvmBaseInfo.put(KEY_VM_VERSION, System.getProperty("java.vm.version"));
        jvmBaseInfo.put(KEY_MAX, Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        jvmBaseInfo.put(KEY_TOTAL, Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        jvmBaseInfo.put(KEY_USED, (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L);
        jvmBaseInfo.put(KEY_AVAILABLE, (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()) / 1024L / 1024L);
        return jvmBaseInfo;
    }

    public static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        return pid;
    }
}

