/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KryoUtil {
    public static <T> T copy(T source) {
        Kryo kryo = KryoUtil.createKryo();
        return (T)kryo.copy(source);
    }

    public static <T> T deepCopy(T source) {
        return (T)KryoUtil.deSerialize(KryoUtil.serialize(source), source.getClass());
    }

    public static byte[] serialize(Object obj) {
        byte[] bytes;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             Output output = new Output((OutputStream)outputStream);){
            Kryo kryo = KryoUtil.createKryo();
            kryo.writeObject(output, obj);
            bytes = output.toBytes();
            output.flush();
            output.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Kryo serialize error" + ex.getMessage());
        }
        return bytes;
    }

    public static <T> T deSerialize(byte[] param, Class<T> clazz) {
        Object object;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(param);
             Input input = new Input((InputStream)inputStream);){
            Kryo kryo = KryoUtil.createKryo();
            object = kryo.readObject(input, clazz);
            input.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Kryo deSerialize error" + e.getMessage());
        }
        return (T)object;
    }

    private static Kryo createKryo() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        return kryo;
    }
}

