/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.ConvertUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;

public class MapUtil {
    public static String getString(Map<String, Object> data, String key) {
        return MapUtil.getString(data, key, null);
    }

    public static String getString(Map<String, Object> data, String key, String defaultValue) {
        String r = MapUtil.get(data, key, String.class, defaultValue);
        return r;
    }

    public static String getString(Map<String, Object> data, String key, String defaultValue, Boolean isBlankUseDefault) {
        String r = MapUtil.get(data, key, null, defaultValue);
        if (StringUtil.isBlank((CharSequence)r) && isBlankUseDefault.booleanValue()) {
            if (null == defaultValue) {
                return null;
            }
            return defaultValue.intern();
        }
        return r.intern();
    }

    public static Float getFloat(Map<String, Object> data, String key) {
        return MapUtil.getFloat(data, key, null);
    }

    public static Float getFloat(Map<String, Object> data, String key, Float f) {
        Float r = MapUtil.get(data, key, Float.class, f);
        return r;
    }

    public static Double getDouble(Map<String, Object> data, String key) {
        return MapUtil.getDouble(data, key, null);
    }

    public static Double getDouble(Map<String, Object> data, String key, Double d) {
        Double r = MapUtil.get(data, key, null, d);
        return r;
    }

    public static Long getLong(Map<String, Object> data, String key) {
        return MapUtil.getLong(data, key, null);
    }

    public static Long getLong(Map<String, Object> data, String key, Long d) {
        Long r = MapUtil.get(data, key, null, d);
        return r;
    }

    public static Integer getInteger(Map<String, Object> data, String key) {
        return MapUtil.getInteger(data, key, null);
    }

    public static Integer getInteger(Map<String, Object> data, String key, Integer i) {
        Integer r = MapUtil.get(data, key, Integer.class, i);
        return r;
    }

    public static Float getFloatOrDoubleOrInteger(Map<String, Object> data, String key) {
        return MapUtil.getFloatOrDoubleOrInteger(data, key, null);
    }

    public static Float getFloatOrDoubleOrInteger(Map<String, Object> data, String key, Float f) {
        try {
            Double r = MapUtil.get(data, key, Double.class, null);
            return Float.valueOf(r == null ? (f == null ? 0.0f : f.floatValue()) : (float)(r * 1.0));
        }
        catch (ClassCastException e) {
            try {
                Float r = MapUtil.get(data, key, Float.class, f);
                return r;
            }
            catch (ClassCastException e1) {
                Integer r = MapUtil.get(data, key, Integer.class, null);
                return Float.valueOf(r == null ? (f == null ? 0.0f : f.floatValue()) : (float)r.intValue() * 1.0f);
            }
        }
    }

    public static List<Float> getFloatsOrDoubleOrInteger(Map<String, Object> data, String key) {
        return MapUtil.getFloatsOrDoubleOrInteger(data, key, null);
    }

    public static List<Float> getFloatsOrDoubleOrInteger(Map<String, Object> data, String key, List<Float> f) {
        ArrayList<Float> result = new ArrayList<Float>();
        List objects = (List)MapUtil.get(data, key);
        if (objects == null) {
            return f;
        }
        for (Object object : objects) {
            result.add(ConvertUtil.convertToFloat(object));
        }
        return result;
    }

    public static Boolean getBoolean(Map<String, Object> data, String key) {
        return MapUtil.getBoolean(data, key, null);
    }

    public static Boolean getBoolean(Map<String, Object> data, String key, Boolean b) {
        Boolean r = MapUtil.get(data, key, Boolean.class, b);
        return r;
    }

    public static Byte getByte(Map<String, Object> data, String key) {
        return MapUtil.getByte(data, key, null);
    }

    public static Byte getByte(Map<String, Object> data, String key, Byte b) {
        Byte r = MapUtil.get(data, key, Byte.class, b);
        return r;
    }

    public static Short getShort(Map<String, Object> data, String key) {
        return MapUtil.getShort(data, key, null);
    }

    public static Short getShort(Map<String, Object> data, String key, Short s) {
        Short r = MapUtil.get(data, key, Short.class, s);
        return r;
    }

    public static <R> R get(Map<String, Object> data, String key) {
        return MapUtil.get(data, key, null);
    }

    public static <R> R get(Map<String, Object> data, String key, R defaultValue) {
        R r = MapUtil.get(data, key, null, defaultValue);
        return r;
    }

    public static <R> R get(Map<String, Object> data, String key, @Nullable Class<R> targetType, R defaultValue) {
        if (BeanUtils.isEmpty(data)) {
            return defaultValue;
        }
        R r = ConvertUtil.convertValueIfNecessary(data.get(key), targetType, defaultValue);
        return r;
    }

    public static <R> R getCaseInsensitive(Map<String, Object> data, String key) {
        return MapUtil.getCaseInsensitive(data, key, null);
    }

    public static <R> R getCaseInsensitive(Map<String, Object> data, String key, R defaultValue) {
        R r = MapUtil.getCaseInsensitive(data, key, null, defaultValue);
        return r;
    }

    public static <R> R getCaseInsensitive(Map<String, Object> data, String key, @Nullable Class<R> targetType, R defaultValue) {
        if (BeanUtils.isEmpty(data)) {
            return defaultValue;
        }
        Object value = null;
        Set<Map.Entry<String, Object>> entries = data.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            value = entry.getValue();
            break;
        }
        R r = ConvertUtil.convertValueIfNecessary(value, targetType, defaultValue);
        return r;
    }
}

