/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.google.common.collect.Maps;
import com.lc.ibps.base.core.config.CommonConfig;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.EnvUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtil {
    private static String LOCK = new String("0");
    private static final Map<Character, String[]> HAN_YU_PIN_YINMAP_MAP = Maps.newHashMapWithExpectedSize((int)100);

    private PinyinUtil() {
    }

    public static String getPinyin(String chinese) {
        return PinyinUtil.getPinyinZhCN(PinyinUtil.convertStringByChinese(chinese));
    }

    public static String getPinyinToUpperCase(String chinese) {
        return PinyinUtil.getPinyinZhCN(PinyinUtil.convertStringByChinese(chinese)).toUpperCase();
    }

    public static String getPinyinToLowerCase(String chinese) {
        return PinyinUtil.getPinyinZhCN(PinyinUtil.convertStringByChinese(chinese)).toLowerCase();
    }

    public static String getPinyinFirstToUpperCase(String chinese) {
        return PinyinUtil.getPinyin(chinese);
    }

    private static HanyuPinyinOutputFormat getDefaultFormat() {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_U_AND_COLON);
        return format;
    }

    private static Set<String> convertStringByChinese(String chinese) {
        if (chinese != null && !chinese.trim().equalsIgnoreCase("")) {
            char[] chars = chinese.toCharArray();
            char[] srcChar = chinese.toCharArray();
            String[][] temp = new String[chinese.length()][];
            for (int i = 0; i < srcChar.length; ++i) {
                char c = srcChar[i];
                if (String.valueOf(c).matches("[\\u4E00-\\u9FA5]+") || String.valueOf(c).matches("[\\u3007]")) {
                    try {
                        temp[i] = PinyinHelper.toHanyuPinyinStringArray((char)chars[i], (HanyuPinyinOutputFormat)PinyinUtil.getDefaultFormat());
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                temp[i] = new String[]{String.valueOf(srcChar[i])};
            }
            String[] pingyinArray = PinyinUtil.exchange(temp);
            HashSet<String> pinyin = new HashSet<String>();
            for (int i = 0; i < pingyinArray.length; ++i) {
                pinyin.add(pingyinArray[i]);
            }
            return pinyin;
        }
        return Collections.emptySet();
    }

    private static String[] exchange(String[][] strJaggedArray) {
        String[][] temp = PinyinUtil.doExchange(strJaggedArray);
        return temp[0];
    }

    private static String[][] doExchange(String[][] strJaggedArray) {
        int len = strJaggedArray.length;
        if (len >= 2) {
            int len1 = strJaggedArray[0].length;
            int len2 = strJaggedArray[1].length;
            int newlen = len1 * len2;
            String[] temp = new String[newlen];
            int index = 0;
            for (int i = 0; i < len1; ++i) {
                for (int j = 0; j < len2; ++j) {
                    temp[index] = StringUtil.build(PinyinUtil.capitalize(strJaggedArray[0][i]), PinyinUtil.capitalize(strJaggedArray[1][j]));
                    ++index;
                }
            }
            String[][] newArray = new String[len - 1][];
            for (int i = 2; i < len; ++i) {
                newArray[i - 1] = strJaggedArray[i];
            }
            newArray[0] = temp;
            return PinyinUtil.doExchange(newArray);
        }
        return strJaggedArray;
    }

    private static String capitalize(String s) {
        char[] ch = s.toCharArray();
        if (ch != null && ch.length > 0 && ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }

    private static String getPinyinZhCN(Set<String> stringSet) {
        if (null == stringSet) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        Iterator<String> iterator = stringSet.iterator();
        while (iterator.hasNext()) {
            str.append(iterator.next()).append(",");
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }

    public static String getPinYinHeadChar(String chinese) {
        StringBuilder pinyin = new StringBuilder();
        if (chinese != null && !chinese.trim().equalsIgnoreCase("")) {
            for (int j = 0; j < chinese.length(); ++j) {
                char word = chinese.charAt(j);
                String[] pinyinArray = PinyinUtil.toHanyuPinyinStringArray(word);
                if (pinyinArray != null) {
                    pinyin.append(pinyinArray[0].charAt(0));
                    continue;
                }
                pinyin.append(word);
            }
        }
        return pinyin.toString();
    }

    private static boolean isLockEnabled() {
        CommonConfig commonConfig = EnvUtil.getBean(CommonConfig.class);
        return commonConfig.isHanyuPinyinLockEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] toHanyuPinyinStringArray(char word) {
        String[] pinyinArray = HAN_YU_PIN_YINMAP_MAP.get(Character.valueOf(word));
        if (BeanUtils.isEmpty(pinyinArray)) {
            if (PinyinUtil.isLockEnabled()) {
                String string = LOCK;
                synchronized (string) {
                    pinyinArray = HAN_YU_PIN_YINMAP_MAP.get(Character.valueOf(word));
                    if (BeanUtils.isEmpty(pinyinArray)) {
                        pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
                    }
                }
            } else {
                pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            }
            HAN_YU_PIN_YINMAP_MAP.put(Character.valueOf(word), pinyinArray);
        }
        return pinyinArray;
    }

    public static String strFilter(String str) {
        Pattern p = Pattern.compile("[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\"]");
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static String getPinYinHeadCharFilter(String chinese) {
        return PinyinUtil.strFilter(PinyinUtil.getPinYinHeadChar(chinese));
    }
}

