/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.lc.ibps.base.core.context.ThreadContext;
import com.lc.ibps.base.core.thread.DateFormatThreadUtil;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.EnvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadContextUtil.class);
    private static ThreadContextUtil contextUtil;
    private ThreadContext threadContext;

    public ThreadContextUtil init() {
        this.threadContext = EnvUtil.getBean(ThreadContext.class);
        if (BeanUtils.isEmpty(this.threadContext) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("ThreadContext is null.");
        }
        contextUtil = this;
        return this;
    }

    public static Object getProperty(String context, String key) {
        return ThreadContextUtil.contextUtil.threadContext.getProperty(context, key);
    }

    public static void addProperty(String context, String key, Object val) {
        ThreadContextUtil.contextUtil.threadContext.addProperty(context, key, val);
    }

    public static void cleanProperty(String context, String key) {
        ThreadContextUtil.contextUtil.threadContext.cleanProperty(context, key);
    }

    public static Object getProperty(String key) {
        return ThreadContextUtil.contextUtil.threadContext.getProperty(key);
    }

    public static void addProperty(String key, Object val) {
        ThreadContextUtil.contextUtil.threadContext.addProperty(key, val);
    }

    public static void cleanProperty(String key) {
        ThreadContextUtil.contextUtil.threadContext.cleanProperty(key);
    }

    public static void clean(String context) {
        ThreadContextUtil.contextUtil.threadContext.clean(context);
    }

    public static void cleanAll() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("current context Thread ID: {}", (Object)Thread.currentThread().getId());
        }
        ThreadContextUtil.contextUtil.threadContext.cleanAll();
        DateFormatThreadUtil.cleanAll();
    }
}

