/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.image.ThumbnailsImgFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailatorImageUtil {
    private static final Logger logger = LoggerFactory.getLogger(ThumbnailatorImageUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream merge(String[] files, int type) {
        int len = files.length;
        if (len < 1) {
            return null;
        }
        File[] src = new File[len];
        BufferedImage[] images = new BufferedImage[len];
        int[][] ImageArrays = new int[len][];
        for (int i = 0; i < len; ++i) {
            BufferedImage image = null;
            try {
                src[i] = new File(files[i]);
                image = images[i] = ImageIO.read(src[i]);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            if (!BeanUtils.isNotEmpty(image)) continue;
            int width = image.getWidth();
            int height = image.getHeight();
            ImageArrays[i] = new int[width * height];
            ImageArrays[i] = image.getRGB(0, 0, width, height, ImageArrays[i], 0, width);
        }
        int newHeight = 0;
        int newWidth = 0;
        for (int i = 0; i < images.length; ++i) {
            BufferedImage image = images[i];
            if (BeanUtils.isEmpty(image)) continue;
            if (type == 1) {
                newHeight = newHeight > image.getHeight() ? image.getHeight() : image.getHeight();
                newWidth += images[i].getWidth();
                continue;
            }
            if (type != 2) continue;
            newWidth = newWidth > image.getWidth() ? image.getWidth() : image.getWidth();
            newHeight += image.getHeight();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u62fc\u63a5\u540e\u56fe\u50cf\u5bbd\u5ea6\uff1a" + newWidth);
            logger.debug("\u62fc\u63a5\u540e\u56fe\u50cf\u9ad8\u5ea6\uff1a" + newHeight);
        }
        if (type == 1 && newWidth < 1) {
            if (logger.isWarnEnabled()) {
                logger.warn("\u62fc\u63a5\u540e\u56fe\u50cf\u5bbd\u5ea6\u5c0f\u4e8e1");
            }
            return null;
        }
        if (type == 2 && newHeight < 1) {
            if (logger.isWarnEnabled()) {
                logger.warn("\u62fc\u63a5\u540e\u56fe\u50cf\u9ad8\u5ea6\u5c0f\u4e8e1");
            }
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            ByteArrayInputStream in;
            BufferedImage imageNew = new BufferedImage(newWidth, newHeight, 1);
            Graphics2D graphics = imageNew.createGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, newWidth, newHeight);
            graphics.dispose();
            int height_i = 0;
            int width_i = 0;
            for (int i = 0; i < images.length; ++i) {
                BufferedImage image = images[i];
                if (BeanUtils.isEmpty(image)) continue;
                if (type == 1) {
                    imageNew.setRGB(width_i, 0, image.getWidth(), newHeight, ImageArrays[i], 0, image.getWidth());
                    width_i += image.getWidth();
                    continue;
                }
                if (type != 2) continue;
                imageNew.setRGB(0, height_i, newWidth, image.getHeight(), ImageArrays[i], 0, newWidth);
                height_i += image.getHeight();
            }
            out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)imageNew, "jpg", out);
            ByteArrayInputStream byteArrayInputStream = in = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (Objects.nonNull(out)) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] getImageByBase64(String imgStr) {
        if (BeanUtils.isEmpty(imgStr)) {
            return null;
        }
        imgStr = imgStr.replaceFirst("data\\:image/[A-Za-z]*;base64,", "");
        try {
            return Base64.getDecoder().decode(imgStr);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] imageBytes, long destFileSize, String imageId, double scale, double quality) {
        long srcSize = imageBytes.length;
        if (imageBytes == null || srcSize <= 0L || srcSize < destFileSize * 1024L) {
            return imageBytes;
        }
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(imageBytes);
            outputStream = new ByteArrayOutputStream(imageBytes.length);
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(scale).outputQuality(quality).toOutputStream((OutputStream)outputStream);
            imageBytes = outputStream.toByteArray();
            if (logger.isDebugEnabled()) {
                logger.debug("Image compress -> imageId={} | size: {}kb -> {}kb", new Object[]{imageId, srcSize / 1024L, imageBytes.length / 1024});
            }
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("\u56fe\u7247\u538b\u7f29\u5931\u8d25!", (Throwable)e);
            }
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (Objects.nonNull(outputStream)) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(byte[] imageBytes, long destFileSize, String imageId, double scale, double quality, String outFilepath) {
        long srcSize = imageBytes.length;
        if (imageBytes == null || srcSize <= 0L || srcSize < destFileSize * 1024L) {
            return;
        }
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(imageBytes);
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(scale).outputQuality(quality).toFile(outFilepath);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("\u56fe\u7247\u538b\u7f29\u5931\u8d25!", (Throwable)e);
            }
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] rotate(byte[] imageBytes, String imageId, double angle) {
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(imageBytes);
            outputStream = new ByteArrayOutputStream(imageBytes.length);
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(1.0).rotate(angle).toOutputStream((OutputStream)outputStream);
            imageBytes = outputStream.toByteArray();
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("\u56fe\u7247\u65cb\u8f6c\u5931\u8d25!", (Throwable)e);
            }
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (Objects.nonNull(outputStream)) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] watermark(byte[] imageBytes, String imageId, Position position, BufferedImage image, float opacity) {
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        ByteArrayInputStream inputStreamTmp = null;
        try {
            inputStream = new ByteArrayInputStream(imageBytes);
            outputStream = new ByteArrayOutputStream(imageBytes.length);
            inputStreamTmp = new ByteArrayInputStream(imageBytes);
            BufferedImage bufferedImage = ImageIO.read(inputStreamTmp);
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(bufferedImage.getWidth(), bufferedImage.getHeight()).watermark(position, image, opacity).toOutputStream((OutputStream)outputStream);
            imageBytes = outputStream.toByteArray();
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("\u56fe\u7247\u6dfb\u52a0\u6c34\u5370\u5931\u8d25!", (Throwable)e);
            }
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (Objects.nonNull(outputStream)) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (Objects.nonNull(inputStreamTmp)) {
                try {
                    inputStreamTmp.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] transfer(byte[] imageBytes, String imageId, String format, double scale, double quality) {
        format = Optional.ofNullable(format).orElse("").toUpperCase();
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(imageBytes);
            outputStream = new ByteArrayOutputStream(imageBytes.length);
            switch (format) {
                case "JPG": {
                    Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(scale).addFilter((ImageFilter)new ThumbnailsImgFilter()).outputFormat("jpg").outputQuality(quality).toOutputStream((OutputStream)outputStream);
                    break;
                }
                case "PNG": {
                    Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(scale).outputFormat("png").outputQuality(quality).toOutputStream((OutputStream)outputStream);
                    break;
                }
                case "BMP": {
                    Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(scale).addFilter((ImageFilter)new ThumbnailsImgFilter()).outputFormat("bmp").outputQuality(quality).toOutputStream((OutputStream)outputStream);
                    break;
                }
                default: {
                    Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(scale).imageType(2).outputQuality(quality).toOutputStream((OutputStream)outputStream);
                }
            }
            imageBytes = outputStream.toByteArray();
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error("\u56fe\u7247\u8f6c\u6362\u5931\u8d25!", (Throwable)e);
            }
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (Objects.nonNull(outputStream)) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageBytes;
    }
}

