/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util;

import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    private static final Logger logger = LoggerFactory.getLogger(XmlUtil.class);

    private XmlUtil() {
    }

    public static String getXML(Element element) {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource();
            source.setNode(element);
            StreamResult result = new StreamResult();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            result.setOutputStream(baos);
            transformer.transform(source, result);
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            logger.error("read xml failed.", e.getCause());
            return "";
        }
    }

    public static Element getChildNodeByName(Element ruleNode, String name) {
        NodeList nodeList = ruleNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element node = XmlUtil.getElement(nodeList.item(i));
            if (node == null || node.getTagName() == null || !node.getTagName().equalsIgnoreCase(name)) continue;
            return node;
        }
        return null;
    }

    private static Element getElement(Object object) {
        if (object != null && object instanceof Element) {
            return (Element)object;
        }
        return null;
    }

    public static Document getDocument(String xmlFilePath) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(xmlFilePath);
        }
        catch (Exception e) {
            logger.error("read xml failed.", e.getCause());
        }
        return doc;
    }

    public static NodeList selectNodes(String express, Object source) {
        NodeList result = null;
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try {
            result = (NodeList)xpath.evaluate(express, source, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            logger.error("read xml failed.", e.getCause());
        }
        return result;
    }

    public static Element selectFirstElement(String express, Object source) {
        NodeList list = XmlUtil.selectNodes(express, source);
        if (null == list) {
            return null;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node obj = list.item(i);
            if (!(obj instanceof Element)) continue;
            return (Element)obj;
        }
        return null;
    }
}

